<?php
/**
 * Configuration
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2023-08-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Cashfree\ApiException;
use Cashfree\ObjectSerializer;
use Exception;

class PGWebhookEvent 
{ 
    public $type;
    public $rawBody;
    public $object;
  
    // Constructor 
    public function __construct($type, $rawBody, $object){ 
        $this->type = $type;
        $this->rawBody = $rawBody;
        $this->object = $object;
    } 
}

class Cashfree {

    protected $client;
    protected $headerSelector;

    public static $XClientId = "";
    public static $XClientSecret = "";
    public static $XPartnerApiKey = "";
    public static $XPartnerMerchantId = "";
    public static $XClientSignature = "";
    public static $XEnvironment = 0;
    public static $XEnableErrorAnalytics = true;
    public static $XApiVersion = "2023-08-01";

    public static $SANDBOX = 0;
    public static $PRODUCTION = 1;

    public function PGVerifyWebhookSignature($signature, $rawBody, $timestamp) {
        $body = $timestamp . $rawBody;
        $secretKey = Cashfree::$XClientSecret;
        $genSignature = hash_hmac('sha256', $body, $secretKey, true);
        $genSignatureBase64 = base64_encode($genSignature);
        if($genSignatureBase64 == $signature) {
            $jsonResponse = json_decode($rawBody);
            return new PGWebhookEvent($jsonResponse->type, $rawBody, $jsonResponse);
        }
        throw new Exception("Generated signature and received signature did not match.");
    }

    public const contentTypes = [
        'pGCreateCustomer' => [
            'application/json',
        ],
        'pGESCreateOnDemandTransfer' => [
            'application/json',
        ],
        'pGESCreateVendors' => [
            'application/json',
        ],
        'pGESDownloadVendorsDocs' => [
            'application/json',
        ],
        'pGESFetchVendors' => [
            'application/json',
        ],
        'pGESGetVendorBalance' => [
            'application/json',
        ],
        'pGESGetVendorBalanceTransferCharges' => [
            'application/json',
        ],
        'pGESGetVendorsDocs' => [
            'application/json',
        ],
        'pGESOrderRecon' => [
            'application/json',
        ],
        'pGESUpdateVendors' => [
            'application/json',
        ],
        'pGESUploadVendorsDocs' => [
            'multipart/form-data',
        ],
        'pGOrderSplitAfterPayment' => [
            'application/json',
        ],
        'pGOrderStaticSplit' => [
            'application/json',
        ],
        'pGEligibilityFetchCardlessEMI' => [
            'application/json',
        ],
        'pGEligibilityFetchOffers' => [
            'application/json',
        ],
        'pGEligibilityFetchPaylater' => [
            'application/json',
        ],
        'pGEligibilityFetchPaymentMethods' => [
            'application/json',
        ],
        'pGCreateOffer' => [
            'application/json',
        ],
        'pGFetchOffer' => [
            'application/json',
        ],
        'pGCreateOrder' => [
            'application/json',
        ],
        'pGFetchOrder' => [
            'application/json',
        ],
        'pGTerminateOrder' => [
            'application/json',
        ],
        'pGFetchRecon' => [
            'application/json',
        ],
        'pGCancelLink' => [
            'application/json',
        ],
        'pGCreateLink' => [
            'application/json',
        ],
        'pGFetchLink' => [
            'application/json',
        ],
        'pGLinkFetchOrders' => [
            'application/json',
        ],
        'pGAuthorizeOrder' => [
            'application/json',
        ],
        'pGOrderAuthenticatePayment' => [
            'application/json',
        ],
        'pGOrderFetchPayment' => [
            'application/json',
        ],
        'pGOrderFetchPayments' => [
            'application/json',
        ],
        'pGPayOrder' => [
            'application/json',
        ],
        'pGOrderCreateRefund' => [
            'application/json',
        ],
        'pGOrderFetchRefund' => [
            'application/json',
        ],
        'pGOrderFetchRefunds' => [
            'application/json',
        ],
        'pGFetchSettlements' => [
            'application/json',
        ],
        'pGSettlementFetchRecon' => [
            'application/json',
        ],
        'markForSettlement' => [
            'application/json',
        ],
        'pGOrderFetchSettlement' => [
            'application/json',
        ],
        'pGFetchSimulation' => [
            'application/json',
        ],
        'pGSimulatePayment' => [
            'application/json',
        ],
        'sposCreateTerminal' => [
            'application/json',
        ],
        'sposCreateTerminalTransaction' => [
            'application/json',
        ],
        'sposFetchTerminal' => [
            'application/json',
        ],
        'sposFetchTerminalQRCodes' => [
            'application/json',
        ],
        'sposFetchTerminalTransaction' => [
            'application/json',
        ],
        'sposUpdateTerminal' => [
            'application/json',
        ],
        'sposUpdateTerminalStatus' => [
            'application/json',
        ],
        'sposUploadTerminalDocs' => [
            'application/json',
        ],
        'subsCreatePayment' => [
            'application/json',
        ],
        'subsCreatePlan' => [
            'application/json',
        ],
        'subsCreateRefund' => [
            'application/json',
        ],
        'subsCreateSubscription' => [
            'application/json',
        ],
        'subsFetchPlan' => [
            'application/json',
        ],
        'subsFetchSubscription' => [
            'application/json',
        ],
        'subsFetchSubscriptionPayment' => [
            'application/json',
        ],
        'subsFetchSubscriptionPayments' => [
            'application/json',
        ],
        'subsFetchSubscriptionRefund' => [
            'application/json',
        ],
        'subsManageSubscription' => [
            'application/json',
        ],
        'subsManageSubscriptionPayment' => [
            'application/json',
        ],
        'subscriptionDocumentUpload' => [
            'multipart/form-data',
        ],
        'subscriptionEligibility' => [
            'application/json',
        ],
        'pGCustomerDeleteInstrument' => [
            'application/json',
        ],
        'pGCustomerFetchInstrument' => [
            'application/json',
        ],
        'pGCustomerFetchInstruments' => [
            'application/json',
        ],
        'pGCustomerInstrumentsFetchCryptogram' => [
            'application/json',
        ],
    ];



    public function PGCreateCustomer($x_api_version, $create_customer_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGCreateCustomer",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGCreateCustomer'][0];
        $request = $this->pGCreateCustomerRequest($x_api_version, $create_customer_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\CustomerEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\CustomerEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\CustomerEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\CustomerEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\CustomerEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGCreateCustomerRequest($x_api_version, $create_customer_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGCreateCustomer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGCreateCustomer'
            );
        }

        // verify the required parameter 'create_customer_request' is set
        if ($create_customer_request === null || (is_array($create_customer_request) && count($create_customer_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_customer_request when calling pGCreateCustomer'
            );
        }




        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_customer_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_customer_request));
            } else {
                $httpBody = $create_customer_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESCreateOnDemandTransfer($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, $adjust_vendor_balance_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESCreateOnDemandTransfer",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESCreateOnDemandTransfer'][0];
        $request = $this->pGESCreateOnDemandTransferRequest($x_api_version, $vendor_id, $x_request_id, $x_idempotency_key, $adjust_vendor_balance_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\AdjustVendorBalanceResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AdjustVendorBalanceResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AdjustVendorBalanceResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\AdjustVendorBalanceResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AdjustVendorBalanceResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESCreateOnDemandTransferRequest($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, $adjust_vendor_balance_request = null, string $contentType = self::contentTypes['pGESCreateOnDemandTransfer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESCreateOnDemandTransfer'
            );
        }

        // verify the required parameter 'vendor_id' is set
        if ($vendor_id === null || (is_array($vendor_id) && count($vendor_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vendor_id when calling pGESCreateOnDemandTransfer'
            );
        }





        $resourcePath = '/easy-split/vendors/{vendor_id}/transfer';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($vendor_id !== null) {
            $resourcePath = str_replace(
                '{' . 'vendor_id' . '}',
                ObjectSerializer::toPathValue($vendor_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($adjust_vendor_balance_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($adjust_vendor_balance_request));
            } else {
                $httpBody = $adjust_vendor_balance_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESCreateVendors($x_api_version, $x_request_id = null, $x_idempotency_key = null, $create_vendor_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESCreateVendors",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESCreateVendors'][0];
        $request = $this->pGESCreateVendorsRequest($x_api_version, $x_request_id, $x_idempotency_key, $create_vendor_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\CreateVendorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\CreateVendorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\CreateVendorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\CreateVendorResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\CreateVendorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESCreateVendorsRequest($x_api_version, $x_request_id = null, $x_idempotency_key = null, $create_vendor_request = null, string $contentType = self::contentTypes['pGESCreateVendors'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESCreateVendors'
            );
        }





        $resourcePath = '/easy-split/vendors';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_vendor_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_vendor_request));
            } else {
                $httpBody = $create_vendor_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESDownloadVendorsDocs($x_api_version, $doc_type, $vendor_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESDownloadVendorsDocs",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESDownloadVendorsDocs'][0];
        $request = $this->pGESDownloadVendorsDocsRequest($x_api_version, $doc_type, $vendor_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\VendorDocumentDownloadResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\VendorDocumentDownloadResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\VendorDocumentDownloadResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\VendorDocumentDownloadResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\VendorDocumentDownloadResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESDownloadVendorsDocsRequest($x_api_version, $doc_type, $vendor_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGESDownloadVendorsDocs'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESDownloadVendorsDocs'
            );
        }

        // verify the required parameter 'doc_type' is set
        if ($doc_type === null || (is_array($doc_type) && count($doc_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $doc_type when calling pGESDownloadVendorsDocs'
            );
        }

        // verify the required parameter 'vendor_id' is set
        if ($vendor_id === null || (is_array($vendor_id) && count($vendor_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vendor_id when calling pGESDownloadVendorsDocs'
            );
        }




        $resourcePath = '/easy-split/vendor-docs/{vendor_id}/download/{doc_type}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($doc_type !== null) {
            $resourcePath = str_replace(
                '{' . 'doc_type' . '}',
                ObjectSerializer::toPathValue($doc_type),
                $resourcePath
            );
        }
        // path params
        if ($vendor_id !== null) {
            $resourcePath = str_replace(
                '{' . 'vendor_id' . '}',
                ObjectSerializer::toPathValue($vendor_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESFetchVendors($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESFetchVendors",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESFetchVendors'][0];
        $request = $this->pGESFetchVendorsRequest($x_api_version, $vendor_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\VendorEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\VendorEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\VendorEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\VendorEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\VendorEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESFetchVendorsRequest($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGESFetchVendors'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESFetchVendors'
            );
        }

        // verify the required parameter 'vendor_id' is set
        if ($vendor_id === null || (is_array($vendor_id) && count($vendor_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vendor_id when calling pGESFetchVendors'
            );
        }




        $resourcePath = '/easy-split/vendors/{vendor_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($vendor_id !== null) {
            $resourcePath = str_replace(
                '{' . 'vendor_id' . '}',
                ObjectSerializer::toPathValue($vendor_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESGetVendorBalance($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESGetVendorBalance",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESGetVendorBalance'][0];
        $request = $this->pGESGetVendorBalanceRequest($x_api_version, $vendor_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\VendorBalance' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\VendorBalance' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\VendorBalance', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\VendorBalance';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\VendorBalance',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESGetVendorBalanceRequest($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGESGetVendorBalance'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESGetVendorBalance'
            );
        }

        // verify the required parameter 'vendor_id' is set
        if ($vendor_id === null || (is_array($vendor_id) && count($vendor_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vendor_id when calling pGESGetVendorBalance'
            );
        }




        $resourcePath = '/easy-split/vendors/{vendor_id}/balances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($vendor_id !== null) {
            $resourcePath = str_replace(
                '{' . 'vendor_id' . '}',
                ObjectSerializer::toPathValue($vendor_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESGetVendorBalanceTransferCharges($x_api_version, $amount, $rate_type, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESGetVendorBalanceTransferCharges",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESGetVendorBalanceTransferCharges'][0];
        $request = $this->pGESGetVendorBalanceTransferChargesRequest($x_api_version, $amount, $rate_type, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\VendorBalanceTransferCharges' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\VendorBalanceTransferCharges' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\VendorBalanceTransferCharges', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\VendorBalanceTransferCharges';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\VendorBalanceTransferCharges',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESGetVendorBalanceTransferChargesRequest($x_api_version, $amount, $rate_type, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGESGetVendorBalanceTransferCharges'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESGetVendorBalanceTransferCharges'
            );
        }

        // verify the required parameter 'amount' is set
        if ($amount === null || (is_array($amount) && count($amount) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $amount when calling pGESGetVendorBalanceTransferCharges'
            );
        }

        // verify the required parameter 'rate_type' is set
        if ($rate_type === null || (is_array($rate_type) && count($rate_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $rate_type when calling pGESGetVendorBalanceTransferCharges'
            );
        }




        $resourcePath = '/easy-split/amount/{amount}/charges';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $rate_type,
            'rate_type', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($amount !== null) {
            $resourcePath = str_replace(
                '{' . 'amount' . '}',
                ObjectSerializer::toPathValue($amount),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESGetVendorsDocs($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESGetVendorsDocs",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESGetVendorsDocs'][0];
        $request = $this->pGESGetVendorsDocsRequest($x_api_version, $vendor_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\VendorDocumentsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\VendorDocumentsResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\VendorDocumentsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\VendorDocumentsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\VendorDocumentsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESGetVendorsDocsRequest($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGESGetVendorsDocs'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESGetVendorsDocs'
            );
        }

        // verify the required parameter 'vendor_id' is set
        if ($vendor_id === null || (is_array($vendor_id) && count($vendor_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vendor_id when calling pGESGetVendorsDocs'
            );
        }




        $resourcePath = '/easy-split/vendor-docs/{vendor_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($vendor_id !== null) {
            $resourcePath = str_replace(
                '{' . 'vendor_id' . '}',
                ObjectSerializer::toPathValue($vendor_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESOrderRecon($x_api_version, $x_request_id = null, $x_idempotency_key = null, $es_order_recon_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESOrderRecon",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESOrderRecon'][0];
        $request = $this->pGESOrderReconRequest($x_api_version, $x_request_id, $x_idempotency_key, $es_order_recon_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\ESOrderReconResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ESOrderReconResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ESOrderReconResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\ESOrderReconResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ESOrderReconResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESOrderReconRequest($x_api_version, $x_request_id = null, $x_idempotency_key = null, $es_order_recon_request = null, string $contentType = self::contentTypes['pGESOrderRecon'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESOrderRecon'
            );
        }





        $resourcePath = '/split/order/vendor/recon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($es_order_recon_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($es_order_recon_request));
            } else {
                $httpBody = $es_order_recon_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESUpdateVendors($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, $update_vendor_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESUpdateVendors",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESUpdateVendors'][0];
        $request = $this->pGESUpdateVendorsRequest($x_api_version, $vendor_id, $x_request_id, $x_idempotency_key, $update_vendor_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\UpdateVendorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\UpdateVendorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\UpdateVendorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\UpdateVendorResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\UpdateVendorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESUpdateVendorsRequest($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, $update_vendor_request = null, string $contentType = self::contentTypes['pGESUpdateVendors'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESUpdateVendors'
            );
        }

        // verify the required parameter 'vendor_id' is set
        if ($vendor_id === null || (is_array($vendor_id) && count($vendor_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vendor_id when calling pGESUpdateVendors'
            );
        }





        $resourcePath = '/easy-split/vendors/{vendor_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($vendor_id !== null) {
            $resourcePath = str_replace(
                '{' . 'vendor_id' . '}',
                ObjectSerializer::toPathValue($vendor_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($update_vendor_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_vendor_request));
            } else {
                $httpBody = $update_vendor_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGESUploadVendorsDocs($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, $doc_type = null, $doc_value = null, $file = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGESUploadVendorsDocs",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGESUploadVendorsDocs'][0];
        $request = $this->pGESUploadVendorsDocsRequest($x_api_version, $vendor_id, $x_request_id, $x_idempotency_key, $doc_type, $doc_value, $file, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\UploadVendorDocumentsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\UploadVendorDocumentsResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\UploadVendorDocumentsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\UploadVendorDocumentsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\UploadVendorDocumentsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGESUploadVendorsDocsRequest($x_api_version, $vendor_id, $x_request_id = null, $x_idempotency_key = null, $doc_type = null, $doc_value = null, $file = null, string $contentType = self::contentTypes['pGESUploadVendorsDocs'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGESUploadVendorsDocs'
            );
        }

        // verify the required parameter 'vendor_id' is set
        if ($vendor_id === null || (is_array($vendor_id) && count($vendor_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vendor_id when calling pGESUploadVendorsDocs'
            );
        }







        $resourcePath = '/easy-split/vendor-docs/{vendor_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($vendor_id !== null) {
            $resourcePath = str_replace(
                '{' . 'vendor_id' . '}',
                ObjectSerializer::toPathValue($vendor_id),
                $resourcePath
            );
        }

        // form params
        if ($doc_type !== null) {
            $formParams['doc_type'] = ObjectSerializer::toFormValue($doc_type);
        }
        // form params
        if ($doc_value !== null) {
            $formParams['doc_value'] = ObjectSerializer::toFormValue($doc_value);
        }
        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderSplitAfterPayment($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, $split_after_payment_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderSplitAfterPayment",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderSplitAfterPayment'][0];
        $request = $this->pGOrderSplitAfterPaymentRequest($x_api_version, $order_id, $x_request_id, $x_idempotency_key, $split_after_payment_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SplitAfterPaymentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SplitAfterPaymentResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SplitAfterPaymentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SplitAfterPaymentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SplitAfterPaymentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderSplitAfterPaymentRequest($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, $split_after_payment_request = null, string $contentType = self::contentTypes['pGOrderSplitAfterPayment'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderSplitAfterPayment'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGOrderSplitAfterPayment'
            );
        }





        $resourcePath = '/easy-split/orders/{order_id}/split';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($split_after_payment_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($split_after_payment_request));
            } else {
                $httpBody = $split_after_payment_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderStaticSplit($x_api_version, $x_request_id = null, $x_idempotency_key = null, $static_split_request = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderStaticSplit",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderStaticSplit'][0];
        $request = $this->pGOrderStaticSplitRequest($x_api_version, $x_request_id, $x_idempotency_key, $static_split_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\StaticSplitResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\StaticSplitResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\StaticSplitResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\StaticSplitResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\StaticSplitResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderStaticSplitRequest($x_api_version, $x_request_id = null, $x_idempotency_key = null, $static_split_request = null, string $contentType = self::contentTypes['pGOrderStaticSplit'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderStaticSplit'
            );
        }





        $resourcePath = '/easy-split/static-split';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($static_split_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($static_split_request));
            } else {
                $httpBody = $static_split_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGEligibilityFetchCardlessEMI($x_api_version, $eligibility_fetch_cardless_emi_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGEligibilityFetchCardlessEMI",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGEligibilityFetchCardlessEMI'][0];
        $request = $this->pGEligibilityFetchCardlessEMIRequest($x_api_version, $eligibility_fetch_cardless_emi_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\EligibilityCardlessEMIEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\EligibilityCardlessEMIEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\EligibilityCardlessEMIEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\EligibilityCardlessEMIEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\EligibilityCardlessEMIEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGEligibilityFetchCardlessEMIRequest($x_api_version, $eligibility_fetch_cardless_emi_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGEligibilityFetchCardlessEMI'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGEligibilityFetchCardlessEMI'
            );
        }

        // verify the required parameter 'eligibility_fetch_cardless_emi_request' is set
        if ($eligibility_fetch_cardless_emi_request === null || (is_array($eligibility_fetch_cardless_emi_request) && count($eligibility_fetch_cardless_emi_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $eligibility_fetch_cardless_emi_request when calling pGEligibilityFetchCardlessEMI'
            );
        }




        $resourcePath = '/eligibility/cardlessemi';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($eligibility_fetch_cardless_emi_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($eligibility_fetch_cardless_emi_request));
            } else {
                $httpBody = $eligibility_fetch_cardless_emi_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGEligibilityFetchOffers($x_api_version, $eligibility_fetch_offers_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGEligibilityFetchOffers",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGEligibilityFetchOffers'][0];
        $request = $this->pGEligibilityFetchOffersRequest($x_api_version, $eligibility_fetch_offers_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\EligibilityOfferEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\EligibilityOfferEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\EligibilityOfferEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\EligibilityOfferEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\EligibilityOfferEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGEligibilityFetchOffersRequest($x_api_version, $eligibility_fetch_offers_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGEligibilityFetchOffers'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGEligibilityFetchOffers'
            );
        }

        // verify the required parameter 'eligibility_fetch_offers_request' is set
        if ($eligibility_fetch_offers_request === null || (is_array($eligibility_fetch_offers_request) && count($eligibility_fetch_offers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $eligibility_fetch_offers_request when calling pGEligibilityFetchOffers'
            );
        }




        $resourcePath = '/eligibility/offers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($eligibility_fetch_offers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($eligibility_fetch_offers_request));
            } else {
                $httpBody = $eligibility_fetch_offers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGEligibilityFetchPaylater($x_api_version, $eligibility_fetch_paylater_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGEligibilityFetchPaylater",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGEligibilityFetchPaylater'][0];
        $request = $this->pGEligibilityFetchPaylaterRequest($x_api_version, $eligibility_fetch_paylater_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\EligibilityPaylaterEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\EligibilityPaylaterEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\EligibilityPaylaterEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\EligibilityPaylaterEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\EligibilityPaylaterEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGEligibilityFetchPaylaterRequest($x_api_version, $eligibility_fetch_paylater_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGEligibilityFetchPaylater'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGEligibilityFetchPaylater'
            );
        }

        // verify the required parameter 'eligibility_fetch_paylater_request' is set
        if ($eligibility_fetch_paylater_request === null || (is_array($eligibility_fetch_paylater_request) && count($eligibility_fetch_paylater_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $eligibility_fetch_paylater_request when calling pGEligibilityFetchPaylater'
            );
        }




        $resourcePath = '/eligibility/paylater';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($eligibility_fetch_paylater_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($eligibility_fetch_paylater_request));
            } else {
                $httpBody = $eligibility_fetch_paylater_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGEligibilityFetchPaymentMethods($x_api_version, $eligibility_fetch_payment_methods_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGEligibilityFetchPaymentMethods",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGEligibilityFetchPaymentMethods'][0];
        $request = $this->pGEligibilityFetchPaymentMethodsRequest($x_api_version, $eligibility_fetch_payment_methods_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\EligibilityPaymentMethodsEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\EligibilityPaymentMethodsEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\EligibilityPaymentMethodsEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\EligibilityPaymentMethodsEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\EligibilityPaymentMethodsEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGEligibilityFetchPaymentMethodsRequest($x_api_version, $eligibility_fetch_payment_methods_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGEligibilityFetchPaymentMethods'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGEligibilityFetchPaymentMethods'
            );
        }

        // verify the required parameter 'eligibility_fetch_payment_methods_request' is set
        if ($eligibility_fetch_payment_methods_request === null || (is_array($eligibility_fetch_payment_methods_request) && count($eligibility_fetch_payment_methods_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $eligibility_fetch_payment_methods_request when calling pGEligibilityFetchPaymentMethods'
            );
        }




        $resourcePath = '/eligibility/payment_methods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($eligibility_fetch_payment_methods_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($eligibility_fetch_payment_methods_request));
            } else {
                $httpBody = $eligibility_fetch_payment_methods_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGCreateOffer($x_api_version, $create_offer_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGCreateOffer",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGCreateOffer'][0];
        $request = $this->pGCreateOfferRequest($x_api_version, $create_offer_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\OfferEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\OfferEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\OfferEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\OfferEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\OfferEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGCreateOfferRequest($x_api_version, $create_offer_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGCreateOffer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGCreateOffer'
            );
        }

        // verify the required parameter 'create_offer_request' is set
        if ($create_offer_request === null || (is_array($create_offer_request) && count($create_offer_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_offer_request when calling pGCreateOffer'
            );
        }




        $resourcePath = '/offers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_offer_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_offer_request));
            } else {
                $httpBody = $create_offer_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGFetchOffer($x_api_version, $offer_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGFetchOffer",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGFetchOffer'][0];
        $request = $this->pGFetchOfferRequest($x_api_version, $offer_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\OfferEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\OfferEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\OfferEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\OfferEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\OfferEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGFetchOfferRequest($x_api_version, $offer_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGFetchOffer'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGFetchOffer'
            );
        }

        // verify the required parameter 'offer_id' is set
        if ($offer_id === null || (is_array($offer_id) && count($offer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $offer_id when calling pGFetchOffer'
            );
        }




        $resourcePath = '/offers/{offer_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($offer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'offer_id' . '}',
                ObjectSerializer::toPathValue($offer_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGCreateOrder($x_api_version, $create_order_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGCreateOrder",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGCreateOrder'][0];
        $request = $this->pGCreateOrderRequest($x_api_version, $create_order_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\OrderEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\OrderEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\OrderEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\OrderEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\OrderEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGCreateOrderRequest($x_api_version, $create_order_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGCreateOrder'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGCreateOrder'
            );
        }

        // verify the required parameter 'create_order_request' is set
        if ($create_order_request === null || (is_array($create_order_request) && count($create_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_order_request when calling pGCreateOrder'
            );
        }




        $resourcePath = '/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_order_request));
            } else {
                $httpBody = $create_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGFetchOrder($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGFetchOrder",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGFetchOrder'][0];
        $request = $this->pGFetchOrderRequest($x_api_version, $order_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\OrderEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\OrderEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\OrderEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\OrderEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\OrderEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGFetchOrderRequest($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGFetchOrder'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGFetchOrder'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGFetchOrder'
            );
        }




        $resourcePath = '/orders/{order_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGTerminateOrder($x_api_version, $order_id, $terminate_order_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGTerminateOrder",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGTerminateOrder'][0];
        $request = $this->pGTerminateOrderRequest($x_api_version, $order_id, $terminate_order_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\OrderEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\OrderEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\OrderEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\OrderEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\OrderEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGTerminateOrderRequest($x_api_version, $order_id, $terminate_order_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGTerminateOrder'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGTerminateOrder'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGTerminateOrder'
            );
        }

        // verify the required parameter 'terminate_order_request' is set
        if ($terminate_order_request === null || (is_array($terminate_order_request) && count($terminate_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $terminate_order_request when calling pGTerminateOrder'
            );
        }




        $resourcePath = '/orders/{order_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($terminate_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($terminate_order_request));
            } else {
                $httpBody = $terminate_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGFetchRecon($x_api_version, $fetch_recon_request, $content_type = null, $x_request_id = null, $x_idempotency_key = null, $accept = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGFetchRecon",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGFetchRecon'][0];
        $request = $this->pGFetchReconRequest($x_api_version, $fetch_recon_request, $content_type, $x_request_id, $x_idempotency_key, $accept, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\ReconEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ReconEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ReconEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\ReconEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ReconEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGFetchReconRequest($x_api_version, $fetch_recon_request, $content_type = null, $x_request_id = null, $x_idempotency_key = null, $accept = null, string $contentType = self::contentTypes['pGFetchRecon'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGFetchRecon'
            );
        }

        // verify the required parameter 'fetch_recon_request' is set
        if ($fetch_recon_request === null || (is_array($fetch_recon_request) && count($fetch_recon_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fetch_recon_request when calling pGFetchRecon'
            );
        }






        $resourcePath = '/recon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($fetch_recon_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($fetch_recon_request));
            } else {
                $httpBody = $fetch_recon_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGCancelLink($x_api_version, $link_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGCancelLink",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGCancelLink'][0];
        $request = $this->pGCancelLinkRequest($x_api_version, $link_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\LinkEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\LinkEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\LinkEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\LinkEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\LinkEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGCancelLinkRequest($x_api_version, $link_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGCancelLink'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGCancelLink'
            );
        }

        // verify the required parameter 'link_id' is set
        if ($link_id === null || (is_array($link_id) && count($link_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $link_id when calling pGCancelLink'
            );
        }




        $resourcePath = '/links/{link_id}/cancel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($link_id !== null) {
            $resourcePath = str_replace(
                '{' . 'link_id' . '}',
                ObjectSerializer::toPathValue($link_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGCreateLink($x_api_version, $create_link_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGCreateLink",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGCreateLink'][0];
        $request = $this->pGCreateLinkRequest($x_api_version, $create_link_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\LinkEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\LinkEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\LinkEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\LinkEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\LinkEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGCreateLinkRequest($x_api_version, $create_link_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGCreateLink'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGCreateLink'
            );
        }

        // verify the required parameter 'create_link_request' is set
        if ($create_link_request === null || (is_array($create_link_request) && count($create_link_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_link_request when calling pGCreateLink'
            );
        }




        $resourcePath = '/links';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_link_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_link_request));
            } else {
                $httpBody = $create_link_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGFetchLink($x_api_version, $link_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGFetchLink",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGFetchLink'][0];
        $request = $this->pGFetchLinkRequest($x_api_version, $link_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\LinkEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\LinkEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\LinkEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\LinkEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\LinkEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGFetchLinkRequest($x_api_version, $link_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGFetchLink'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGFetchLink'
            );
        }

        // verify the required parameter 'link_id' is set
        if ($link_id === null || (is_array($link_id) && count($link_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $link_id when calling pGFetchLink'
            );
        }




        $resourcePath = '/links/{link_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($link_id !== null) {
            $resourcePath = str_replace(
                '{' . 'link_id' . '}',
                ObjectSerializer::toPathValue($link_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGLinkFetchOrders($x_api_version, $link_id, $x_request_id = null, $x_idempotency_key = null, $status = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGLinkFetchOrders",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGLinkFetchOrders'][0];
        $request = $this->pGLinkFetchOrdersRequest($x_api_version, $link_id, $x_request_id, $x_idempotency_key, $status, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\PaymentLinkOrderEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\PaymentLinkOrderEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\PaymentLinkOrderEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\PaymentLinkOrderEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\PaymentLinkOrderEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGLinkFetchOrdersRequest($x_api_version, $link_id, $x_request_id = null, $x_idempotency_key = null, $status = null, string $contentType = self::contentTypes['pGLinkFetchOrders'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGLinkFetchOrders'
            );
        }

        // verify the required parameter 'link_id' is set
        if ($link_id === null || (is_array($link_id) && count($link_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $link_id when calling pGLinkFetchOrders'
            );
        }





        $resourcePath = '/links/{link_id}/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'status', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($link_id !== null) {
            $resourcePath = str_replace(
                '{' . 'link_id' . '}',
                ObjectSerializer::toPathValue($link_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGAuthorizeOrder($x_api_version, $order_id, $authorize_order_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGAuthorizeOrder",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGAuthorizeOrder'][0];
        $request = $this->pGAuthorizeOrderRequest($x_api_version, $order_id, $authorize_order_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\PaymentEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\PaymentEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\PaymentEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\PaymentEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\PaymentEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGAuthorizeOrderRequest($x_api_version, $order_id, $authorize_order_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGAuthorizeOrder'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGAuthorizeOrder'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGAuthorizeOrder'
            );
        }

        // verify the required parameter 'authorize_order_request' is set
        if ($authorize_order_request === null || (is_array($authorize_order_request) && count($authorize_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $authorize_order_request when calling pGAuthorizeOrder'
            );
        }




        $resourcePath = '/orders/{order_id}/authorization';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($authorize_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($authorize_order_request));
            } else {
                $httpBody = $authorize_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderAuthenticatePayment($x_api_version, $cf_payment_id, $order_authenticate_payment_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderAuthenticatePayment",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderAuthenticatePayment'][0];
        $request = $this->pGOrderAuthenticatePaymentRequest($x_api_version, $cf_payment_id, $order_authenticate_payment_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\OrderAuthenticateEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\OrderAuthenticateEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\OrderAuthenticateEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\OrderAuthenticateEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\OrderAuthenticateEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderAuthenticatePaymentRequest($x_api_version, $cf_payment_id, $order_authenticate_payment_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGOrderAuthenticatePayment'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderAuthenticatePayment'
            );
        }

        // verify the required parameter 'cf_payment_id' is set
        if ($cf_payment_id === null || (is_array($cf_payment_id) && count($cf_payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cf_payment_id when calling pGOrderAuthenticatePayment'
            );
        }

        // verify the required parameter 'order_authenticate_payment_request' is set
        if ($order_authenticate_payment_request === null || (is_array($order_authenticate_payment_request) && count($order_authenticate_payment_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_authenticate_payment_request when calling pGOrderAuthenticatePayment'
            );
        }




        $resourcePath = '/orders/pay/authenticate/{cf_payment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($cf_payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cf_payment_id' . '}',
                ObjectSerializer::toPathValue($cf_payment_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($order_authenticate_payment_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_authenticate_payment_request));
            } else {
                $httpBody = $order_authenticate_payment_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderFetchPayment($x_api_version, $order_id, $cf_payment_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderFetchPayment",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderFetchPayment'][0];
        $request = $this->pGOrderFetchPaymentRequest($x_api_version, $order_id, $cf_payment_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\PaymentEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\PaymentEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\PaymentEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\PaymentEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\PaymentEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderFetchPaymentRequest($x_api_version, $order_id, $cf_payment_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGOrderFetchPayment'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderFetchPayment'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGOrderFetchPayment'
            );
        }

        // verify the required parameter 'cf_payment_id' is set
        if ($cf_payment_id === null || (is_array($cf_payment_id) && count($cf_payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cf_payment_id when calling pGOrderFetchPayment'
            );
        }




        $resourcePath = '/orders/{order_id}/payments/{cf_payment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }
        // path params
        if ($cf_payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cf_payment_id' . '}',
                ObjectSerializer::toPathValue($cf_payment_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderFetchPayments($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderFetchPayments",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderFetchPayments'][0];
        $request = $this->pGOrderFetchPaymentsRequest($x_api_version, $order_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\PaymentEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\PaymentEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\PaymentEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\PaymentEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\PaymentEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderFetchPaymentsRequest($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGOrderFetchPayments'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderFetchPayments'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGOrderFetchPayments'
            );
        }




        $resourcePath = '/orders/{order_id}/payments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGPayOrder($x_api_version, $pay_order_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGPayOrder",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGPayOrder'][0];
        $request = $this->pGPayOrderRequest($x_api_version, $pay_order_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\PayOrderEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\PayOrderEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\PayOrderEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\PayOrderEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\PayOrderEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGPayOrderRequest($x_api_version, $pay_order_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGPayOrder'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGPayOrder'
            );
        }

        // verify the required parameter 'pay_order_request' is set
        if ($pay_order_request === null || (is_array($pay_order_request) && count($pay_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_order_request when calling pGPayOrder'
            );
        }




        $resourcePath = '/orders/sessions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($pay_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pay_order_request));
            } else {
                $httpBody = $pay_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderCreateRefund($x_api_version, $order_id, $order_create_refund_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderCreateRefund",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderCreateRefund'][0];
        $request = $this->pGOrderCreateRefundRequest($x_api_version, $order_id, $order_create_refund_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\RefundEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RefundEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RefundEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\RefundEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RefundEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderCreateRefundRequest($x_api_version, $order_id, $order_create_refund_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGOrderCreateRefund'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderCreateRefund'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGOrderCreateRefund'
            );
        }

        // verify the required parameter 'order_create_refund_request' is set
        if ($order_create_refund_request === null || (is_array($order_create_refund_request) && count($order_create_refund_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_create_refund_request when calling pGOrderCreateRefund'
            );
        }




        $resourcePath = '/orders/{order_id}/refunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($order_create_refund_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_create_refund_request));
            } else {
                $httpBody = $order_create_refund_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderFetchRefund($x_api_version, $order_id, $refund_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderFetchRefund",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderFetchRefund'][0];
        $request = $this->pGOrderFetchRefundRequest($x_api_version, $order_id, $refund_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\RefundEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RefundEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RefundEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\RefundEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RefundEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderFetchRefundRequest($x_api_version, $order_id, $refund_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGOrderFetchRefund'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderFetchRefund'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGOrderFetchRefund'
            );
        }

        // verify the required parameter 'refund_id' is set
        if ($refund_id === null || (is_array($refund_id) && count($refund_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $refund_id when calling pGOrderFetchRefund'
            );
        }




        $resourcePath = '/orders/{order_id}/refunds/{refund_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }
        // path params
        if ($refund_id !== null) {
            $resourcePath = str_replace(
                '{' . 'refund_id' . '}',
                ObjectSerializer::toPathValue($refund_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderFetchRefunds($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderFetchRefunds",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderFetchRefunds'][0];
        $request = $this->pGOrderFetchRefundsRequest($x_api_version, $order_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\RefundEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RefundEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RefundEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\RefundEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RefundEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderFetchRefundsRequest($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGOrderFetchRefunds'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderFetchRefunds'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGOrderFetchRefunds'
            );
        }




        $resourcePath = '/orders/{order_id}/refunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGFetchSettlements($x_api_version, $fetch_settlements_request, $content_type = null, $x_request_id = null, $x_idempotency_key = null, $accept = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGFetchSettlements",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGFetchSettlements'][0];
        $request = $this->pGFetchSettlementsRequest($x_api_version, $fetch_settlements_request, $content_type, $x_request_id, $x_idempotency_key, $accept, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SettlementEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SettlementEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SettlementEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SettlementEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SettlementEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGFetchSettlementsRequest($x_api_version, $fetch_settlements_request, $content_type = null, $x_request_id = null, $x_idempotency_key = null, $accept = null, string $contentType = self::contentTypes['pGFetchSettlements'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGFetchSettlements'
            );
        }

        // verify the required parameter 'fetch_settlements_request' is set
        if ($fetch_settlements_request === null || (is_array($fetch_settlements_request) && count($fetch_settlements_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fetch_settlements_request when calling pGFetchSettlements'
            );
        }






        $resourcePath = '/settlements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($fetch_settlements_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($fetch_settlements_request));
            } else {
                $httpBody = $fetch_settlements_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGSettlementFetchRecon($x_api_version, $settlement_fetch_recon_request, $content_type = null, $x_request_id = null, $x_idempotency_key = null, $accept = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGSettlementFetchRecon",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGSettlementFetchRecon'][0];
        $request = $this->pGSettlementFetchReconRequest($x_api_version, $settlement_fetch_recon_request, $content_type, $x_request_id, $x_idempotency_key, $accept, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SettlementReconEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SettlementReconEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SettlementReconEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SettlementReconEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SettlementReconEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGSettlementFetchReconRequest($x_api_version, $settlement_fetch_recon_request, $content_type = null, $x_request_id = null, $x_idempotency_key = null, $accept = null, string $contentType = self::contentTypes['pGSettlementFetchRecon'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGSettlementFetchRecon'
            );
        }

        // verify the required parameter 'settlement_fetch_recon_request' is set
        if ($settlement_fetch_recon_request === null || (is_array($settlement_fetch_recon_request) && count($settlement_fetch_recon_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $settlement_fetch_recon_request when calling pGSettlementFetchRecon'
            );
        }






        $resourcePath = '/settlement/recon';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($settlement_fetch_recon_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($settlement_fetch_recon_request));
            } else {
                $httpBody = $settlement_fetch_recon_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function MarkForSettlement($x_api_version, $x_request_id = null, $x_idempotency_key = null, $create_order_settlement_request_body = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."MarkForSettlement",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['markForSettlement'][0];
        $request = $this->markForSettlementRequest($x_api_version, $x_request_id, $x_idempotency_key, $create_order_settlement_request_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 202:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function markForSettlementRequest($x_api_version, $x_request_id = null, $x_idempotency_key = null, $create_order_settlement_request_body = null, string $contentType = self::contentTypes['markForSettlement'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling markForSettlement'
            );
        }





        $resourcePath = '/orders/settlements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_order_settlement_request_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_order_settlement_request_body));
            } else {
                $httpBody = $create_order_settlement_request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGOrderFetchSettlement($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGOrderFetchSettlement",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGOrderFetchSettlement'][0];
        $request = $this->pGOrderFetchSettlementRequest($x_api_version, $order_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SettlementEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SettlementEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SettlementEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SettlementEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SettlementEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 502:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError502',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGOrderFetchSettlementRequest($x_api_version, $order_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGOrderFetchSettlement'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGOrderFetchSettlement'
            );
        }

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling pGOrderFetchSettlement'
            );
        }




        $resourcePath = '/orders/{order_id}/settlements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGFetchSimulation($x_api_version, $simulation_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGFetchSimulation",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGFetchSimulation'][0];
        $request = $this->pGFetchSimulationRequest($x_api_version, $simulation_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SimulationResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SimulationResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SimulationResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SimulationResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SimulationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGFetchSimulationRequest($x_api_version, $simulation_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGFetchSimulation'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGFetchSimulation'
            );
        }

        // verify the required parameter 'simulation_id' is set
        if ($simulation_id === null || (is_array($simulation_id) && count($simulation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $simulation_id when calling pGFetchSimulation'
            );
        }




        $resourcePath = '/simulate/{simulation_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($simulation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'simulation_id' . '}',
                ObjectSerializer::toPathValue($simulation_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGSimulatePayment($x_api_version, $simulate_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGSimulatePayment",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGSimulatePayment'][0];
        $request = $this->pGSimulatePaymentRequest($x_api_version, $simulate_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SimulationResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SimulationResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SimulationResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SimulationResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SimulationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function pGSimulatePaymentRequest($x_api_version, $simulate_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['pGSimulatePayment'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling pGSimulatePayment'
            );
        }

        // verify the required parameter 'simulate_request' is set
        if ($simulate_request === null || (is_array($simulate_request) && count($simulate_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $simulate_request when calling pGSimulatePayment'
            );
        }




        $resourcePath = '/simulate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($simulate_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($simulate_request));
            } else {
                $httpBody = $simulate_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposCreateTerminal($x_api_version, $create_terminal_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposCreateTerminal",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposCreateTerminal'][0];
        $request = $this->sposCreateTerminalRequest($x_api_version, $create_terminal_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\TerminalEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\TerminalEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\TerminalEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\TerminalEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\TerminalEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposCreateTerminalRequest($x_api_version, $create_terminal_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposCreateTerminal'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposCreateTerminal'
            );
        }

        // verify the required parameter 'create_terminal_request' is set
        if ($create_terminal_request === null || (is_array($create_terminal_request) && count($create_terminal_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_terminal_request when calling sposCreateTerminal'
            );
        }




        $resourcePath = '/terminal';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_terminal_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_terminal_request));
            } else {
                $httpBody = $create_terminal_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposCreateTerminalTransaction($x_api_version, $create_terminal_transaction_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposCreateTerminalTransaction",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposCreateTerminalTransaction'][0];
        $request = $this->sposCreateTerminalTransactionRequest($x_api_version, $create_terminal_transaction_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\TerminalTransactionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\TerminalTransactionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\TerminalTransactionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\TerminalTransactionEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\TerminalTransactionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposCreateTerminalTransactionRequest($x_api_version, $create_terminal_transaction_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposCreateTerminalTransaction'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposCreateTerminalTransaction'
            );
        }

        // verify the required parameter 'create_terminal_transaction_request' is set
        if ($create_terminal_transaction_request === null || (is_array($create_terminal_transaction_request) && count($create_terminal_transaction_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_terminal_transaction_request when calling sposCreateTerminalTransaction'
            );
        }




        $resourcePath = '/terminal/transactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_terminal_transaction_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_terminal_transaction_request));
            } else {
                $httpBody = $create_terminal_transaction_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposFetchTerminal($x_api_version, $terminal_phone_no, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposFetchTerminal",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposFetchTerminal'][0];
        $request = $this->sposFetchTerminalRequest($x_api_version, $terminal_phone_no, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\TerminalEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\TerminalEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\TerminalEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\TerminalEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\TerminalEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposFetchTerminalRequest($x_api_version, $terminal_phone_no, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposFetchTerminal'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposFetchTerminal'
            );
        }

        // verify the required parameter 'terminal_phone_no' is set
        if ($terminal_phone_no === null || (is_array($terminal_phone_no) && count($terminal_phone_no) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $terminal_phone_no when calling sposFetchTerminal'
            );
        }




        $resourcePath = '/terminal/{terminal_phone_no}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($terminal_phone_no !== null) {
            $resourcePath = str_replace(
                '{' . 'terminal_phone_no' . '}',
                ObjectSerializer::toPathValue($terminal_phone_no),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposFetchTerminalQRCodes($x_api_version, $terminal_phone_no, $cf_terminal_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposFetchTerminalQRCodes",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposFetchTerminalQRCodes'][0];
        $request = $this->sposFetchTerminalQRCodesRequest($x_api_version, $terminal_phone_no, $cf_terminal_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\FetchTerminalQRCodesEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\FetchTerminalQRCodesEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\FetchTerminalQRCodesEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\FetchTerminalQRCodesEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\FetchTerminalQRCodesEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposFetchTerminalQRCodesRequest($x_api_version, $terminal_phone_no, $cf_terminal_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposFetchTerminalQRCodes'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposFetchTerminalQRCodes'
            );
        }

        // verify the required parameter 'terminal_phone_no' is set
        if ($terminal_phone_no === null || (is_array($terminal_phone_no) && count($terminal_phone_no) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $terminal_phone_no when calling sposFetchTerminalQRCodes'
            );
        }

        // verify the required parameter 'cf_terminal_id' is set
        if ($cf_terminal_id === null || (is_array($cf_terminal_id) && count($cf_terminal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cf_terminal_id when calling sposFetchTerminalQRCodes'
            );
        }




        $resourcePath = '/terminal/qrcodes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $terminal_phone_no,
            'terminal_phone_no', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $cf_terminal_id,
            'cf_terminal_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposFetchTerminalTransaction($x_api_version, $utr, $cf_terminal_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposFetchTerminalTransaction",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposFetchTerminalTransaction'][0];
        $request = $this->sposFetchTerminalTransactionRequest($x_api_version, $utr, $cf_terminal_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\TerminalPaymentEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\TerminalPaymentEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\TerminalPaymentEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\TerminalPaymentEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\TerminalPaymentEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposFetchTerminalTransactionRequest($x_api_version, $utr, $cf_terminal_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposFetchTerminalTransaction'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposFetchTerminalTransaction'
            );
        }

        // verify the required parameter 'utr' is set
        if ($utr === null || (is_array($utr) && count($utr) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $utr when calling sposFetchTerminalTransaction'
            );
        }

        // verify the required parameter 'cf_terminal_id' is set
        if ($cf_terminal_id === null || (is_array($cf_terminal_id) && count($cf_terminal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cf_terminal_id when calling sposFetchTerminalTransaction'
            );
        }




        $resourcePath = '/terminal/{cf_terminal_id}/payments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $utr,
            'utr', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($cf_terminal_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cf_terminal_id' . '}',
                ObjectSerializer::toPathValue($cf_terminal_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposUpdateTerminal($x_api_version, $cf_terminal_id, $update_terminal_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposUpdateTerminal",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposUpdateTerminal'][0];
        $request = $this->sposUpdateTerminalRequest($x_api_version, $cf_terminal_id, $update_terminal_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\UpdateTerminalEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\UpdateTerminalEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\UpdateTerminalEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\UpdateTerminalEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\UpdateTerminalEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposUpdateTerminalRequest($x_api_version, $cf_terminal_id, $update_terminal_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposUpdateTerminal'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposUpdateTerminal'
            );
        }

        // verify the required parameter 'cf_terminal_id' is set
        if ($cf_terminal_id === null || (is_array($cf_terminal_id) && count($cf_terminal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cf_terminal_id when calling sposUpdateTerminal'
            );
        }

        // verify the required parameter 'update_terminal_request' is set
        if ($update_terminal_request === null || (is_array($update_terminal_request) && count($update_terminal_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_terminal_request when calling sposUpdateTerminal'
            );
        }




        $resourcePath = '/terminal/{cf_terminal_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($cf_terminal_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cf_terminal_id' . '}',
                ObjectSerializer::toPathValue($cf_terminal_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($update_terminal_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_terminal_request));
            } else {
                $httpBody = $update_terminal_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposUpdateTerminalStatus($x_api_version, $cf_terminal_id, $update_terminal_status_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposUpdateTerminalStatus",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposUpdateTerminalStatus'][0];
        $request = $this->sposUpdateTerminalStatusRequest($x_api_version, $cf_terminal_id, $update_terminal_status_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\UpdateTerminalEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\UpdateTerminalEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\UpdateTerminalEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\UpdateTerminalEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\UpdateTerminalEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposUpdateTerminalStatusRequest($x_api_version, $cf_terminal_id, $update_terminal_status_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposUpdateTerminalStatus'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposUpdateTerminalStatus'
            );
        }

        // verify the required parameter 'cf_terminal_id' is set
        if ($cf_terminal_id === null || (is_array($cf_terminal_id) && count($cf_terminal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cf_terminal_id when calling sposUpdateTerminalStatus'
            );
        }

        // verify the required parameter 'update_terminal_status_request' is set
        if ($update_terminal_status_request === null || (is_array($update_terminal_status_request) && count($update_terminal_status_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_terminal_status_request when calling sposUpdateTerminalStatus'
            );
        }




        $resourcePath = '/terminal/{cf_terminal_id}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($cf_terminal_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cf_terminal_id' . '}',
                ObjectSerializer::toPathValue($cf_terminal_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($update_terminal_status_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_terminal_status_request));
            } else {
                $httpBody = $update_terminal_status_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SposUploadTerminalDocs($x_api_version, $cf_terminal_id, $upload_terminal_docs, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SposUploadTerminalDocs",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['sposUploadTerminalDocs'][0];
        $request = $this->sposUploadTerminalDocsRequest($x_api_version, $cf_terminal_id, $upload_terminal_docs, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\UploadTerminalDocsEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\UploadTerminalDocsEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\UploadTerminalDocsEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\UploadTerminalDocsEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\UploadTerminalDocsEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError409',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function sposUploadTerminalDocsRequest($x_api_version, $cf_terminal_id, $upload_terminal_docs, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['sposUploadTerminalDocs'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling sposUploadTerminalDocs'
            );
        }

        // verify the required parameter 'cf_terminal_id' is set
        if ($cf_terminal_id === null || (is_array($cf_terminal_id) && count($cf_terminal_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cf_terminal_id when calling sposUploadTerminalDocs'
            );
        }

        // verify the required parameter 'upload_terminal_docs' is set
        if ($upload_terminal_docs === null || (is_array($upload_terminal_docs) && count($upload_terminal_docs) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $upload_terminal_docs when calling sposUploadTerminalDocs'
            );
        }




        $resourcePath = '/terminal/{cf_terminal_id}/docs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($cf_terminal_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cf_terminal_id' . '}',
                ObjectSerializer::toPathValue($cf_terminal_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($upload_terminal_docs)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($upload_terminal_docs));
            } else {
                $httpBody = $upload_terminal_docs;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsCreatePayment($x_api_version, $create_subscription_payment_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsCreatePayment",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsCreatePayment'][0];
        $request = $this->subsCreatePaymentRequest($x_api_version, $create_subscription_payment_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\CreateSubscriptionPaymentResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\CreateSubscriptionPaymentResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\CreateSubscriptionPaymentResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\CreateSubscriptionPaymentResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\CreateSubscriptionPaymentResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsCreatePaymentRequest($x_api_version, $create_subscription_payment_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsCreatePayment'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsCreatePayment'
            );
        }

        // verify the required parameter 'create_subscription_payment_request' is set
        if ($create_subscription_payment_request === null || (is_array($create_subscription_payment_request) && count($create_subscription_payment_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_subscription_payment_request when calling subsCreatePayment'
            );
        }




        $resourcePath = '/subscriptions/pay';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_subscription_payment_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_subscription_payment_request));
            } else {
                $httpBody = $create_subscription_payment_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsCreatePlan($x_api_version, $create_plan_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsCreatePlan",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsCreatePlan'][0];
        $request = $this->subsCreatePlanRequest($x_api_version, $create_plan_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\PlanEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\PlanEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\PlanEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\PlanEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\PlanEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsCreatePlanRequest($x_api_version, $create_plan_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsCreatePlan'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsCreatePlan'
            );
        }

        // verify the required parameter 'create_plan_request' is set
        if ($create_plan_request === null || (is_array($create_plan_request) && count($create_plan_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_plan_request when calling subsCreatePlan'
            );
        }




        $resourcePath = '/plans';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_plan_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_plan_request));
            } else {
                $httpBody = $create_plan_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsCreateRefund($x_api_version, $subscription_id, $create_subscription_refund_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsCreateRefund",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsCreateRefund'][0];
        $request = $this->subsCreateRefundRequest($x_api_version, $subscription_id, $create_subscription_refund_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionPaymentRefundEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionPaymentRefundEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionPaymentRefundEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionPaymentRefundEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionPaymentRefundEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsCreateRefundRequest($x_api_version, $subscription_id, $create_subscription_refund_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsCreateRefund'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsCreateRefund'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling subsCreateRefund'
            );
        }

        // verify the required parameter 'create_subscription_refund_request' is set
        if ($create_subscription_refund_request === null || (is_array($create_subscription_refund_request) && count($create_subscription_refund_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_subscription_refund_request when calling subsCreateRefund'
            );
        }




        $resourcePath = '/subscriptions/{subscription_id}/refunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($create_subscription_refund_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_subscription_refund_request));
            } else {
                $httpBody = $create_subscription_refund_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsCreateSubscription($x_api_version, $create_subscription_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsCreateSubscription",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsCreateSubscription'][0];
        $request = $this->subsCreateSubscriptionRequest($x_api_version, $create_subscription_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsCreateSubscriptionRequest($x_api_version, $create_subscription_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsCreateSubscription'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsCreateSubscription'
            );
        }

        // verify the required parameter 'create_subscription_request' is set
        if ($create_subscription_request === null || (is_array($create_subscription_request) && count($create_subscription_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_subscription_request when calling subsCreateSubscription'
            );
        }




        $resourcePath = '/subscriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($create_subscription_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_subscription_request));
            } else {
                $httpBody = $create_subscription_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsFetchPlan($x_api_version, $plan_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsFetchPlan",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsFetchPlan'][0];
        $request = $this->subsFetchPlanRequest($x_api_version, $plan_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\PlanEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\PlanEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\PlanEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\PlanEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\PlanEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsFetchPlanRequest($x_api_version, $plan_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsFetchPlan'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsFetchPlan'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling subsFetchPlan'
            );
        }




        $resourcePath = '/plans/{plan_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsFetchSubscription($x_api_version, $subscription_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsFetchSubscription",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsFetchSubscription'][0];
        $request = $this->subsFetchSubscriptionRequest($x_api_version, $subscription_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsFetchSubscriptionRequest($x_api_version, $subscription_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsFetchSubscription'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsFetchSubscription'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling subsFetchSubscription'
            );
        }




        $resourcePath = '/subscriptions/{subscription_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsFetchSubscriptionPayment($x_api_version, $subscription_id, $payment_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsFetchSubscriptionPayment",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsFetchSubscriptionPayment'][0];
        $request = $this->subsFetchSubscriptionPaymentRequest($x_api_version, $subscription_id, $payment_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionPaymentEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionPaymentEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionPaymentEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionPaymentEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionPaymentEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsFetchSubscriptionPaymentRequest($x_api_version, $subscription_id, $payment_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsFetchSubscriptionPayment'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsFetchSubscriptionPayment'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling subsFetchSubscriptionPayment'
            );
        }

        // verify the required parameter 'payment_id' is set
        if ($payment_id === null || (is_array($payment_id) && count($payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id when calling subsFetchSubscriptionPayment'
            );
        }




        $resourcePath = '/subscriptions/{subscription_id}/payments/{payment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }
        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'payment_id' . '}',
                ObjectSerializer::toPathValue($payment_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsFetchSubscriptionPayments($x_api_version, $subscription_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsFetchSubscriptionPayments",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsFetchSubscriptionPayments'][0];
        $request = $this->subsFetchSubscriptionPaymentsRequest($x_api_version, $subscription_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionPaymentEntity[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionPaymentEntity[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionPaymentEntity[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionPaymentEntity[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionPaymentEntity[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsFetchSubscriptionPaymentsRequest($x_api_version, $subscription_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsFetchSubscriptionPayments'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsFetchSubscriptionPayments'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling subsFetchSubscriptionPayments'
            );
        }




        $resourcePath = '/subscriptions/{subscription_id}/payments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsFetchSubscriptionRefund($x_api_version, $subscription_id, $refund_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsFetchSubscriptionRefund",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsFetchSubscriptionRefund'][0];
        $request = $this->subsFetchSubscriptionRefundRequest($x_api_version, $subscription_id, $refund_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionPaymentRefundEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionPaymentRefundEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionPaymentRefundEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionPaymentRefundEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionPaymentRefundEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsFetchSubscriptionRefundRequest($x_api_version, $subscription_id, $refund_id, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsFetchSubscriptionRefund'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsFetchSubscriptionRefund'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling subsFetchSubscriptionRefund'
            );
        }

        // verify the required parameter 'refund_id' is set
        if ($refund_id === null || (is_array($refund_id) && count($refund_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $refund_id when calling subsFetchSubscriptionRefund'
            );
        }




        $resourcePath = '/subscriptions/{subscription_id}/refunds/{refund_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }
        // path params
        if ($refund_id !== null) {
            $resourcePath = str_replace(
                '{' . 'refund_id' . '}',
                ObjectSerializer::toPathValue($refund_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsManageSubscription($x_api_version, $subscription_id, $manage_subscription_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsManageSubscription",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsManageSubscription'][0];
        $request = $this->subsManageSubscriptionRequest($x_api_version, $subscription_id, $manage_subscription_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsManageSubscriptionRequest($x_api_version, $subscription_id, $manage_subscription_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsManageSubscription'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsManageSubscription'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling subsManageSubscription'
            );
        }

        // verify the required parameter 'manage_subscription_request' is set
        if ($manage_subscription_request === null || (is_array($manage_subscription_request) && count($manage_subscription_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manage_subscription_request when calling subsManageSubscription'
            );
        }




        $resourcePath = '/subscriptions/{subscription_id}/manage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($manage_subscription_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($manage_subscription_request));
            } else {
                $httpBody = $manage_subscription_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubsManageSubscriptionPayment($x_api_version, $subscription_id, $payment_id, $manage_subscription_payment_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubsManageSubscriptionPayment",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subsManageSubscriptionPayment'][0];
        $request = $this->subsManageSubscriptionPaymentRequest($x_api_version, $subscription_id, $payment_id, $manage_subscription_payment_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionPaymentEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionPaymentEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionPaymentEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionPaymentEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionPaymentEntity',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subsManageSubscriptionPaymentRequest($x_api_version, $subscription_id, $payment_id, $manage_subscription_payment_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subsManageSubscriptionPayment'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subsManageSubscriptionPayment'
            );
        }

        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling subsManageSubscriptionPayment'
            );
        }

        // verify the required parameter 'payment_id' is set
        if ($payment_id === null || (is_array($payment_id) && count($payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id when calling subsManageSubscriptionPayment'
            );
        }

        // verify the required parameter 'manage_subscription_payment_request' is set
        if ($manage_subscription_payment_request === null || (is_array($manage_subscription_payment_request) && count($manage_subscription_payment_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $manage_subscription_payment_request when calling subsManageSubscriptionPayment'
            );
        }




        $resourcePath = '/subscriptions/{subscription_id}/payments/{payment_id}/manage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscription_id' . '}',
                ObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }
        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'payment_id' . '}',
                ObjectSerializer::toPathValue($payment_id),
                $resourcePath
            );
        }


        // for model (json/xml)
        if (isset($manage_subscription_payment_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($manage_subscription_payment_request));
            } else {
                $httpBody = $manage_subscription_payment_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubscriptionDocumentUpload($x_api_version, $payment_id, $file, $payment_id2, $action, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubscriptionDocumentUpload",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subscriptionDocumentUpload'][0];
        $request = $this->subscriptionDocumentUploadRequest($x_api_version, $payment_id, $file, $payment_id2, $action, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\UploadPnachImageResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\UploadPnachImageResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\UploadPnachImageResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\UploadPnachImageResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\UploadPnachImageResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subscriptionDocumentUploadRequest($x_api_version, $payment_id, $file, $payment_id2, $action, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subscriptionDocumentUpload'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subscriptionDocumentUpload'
            );
        }

        // verify the required parameter 'payment_id' is set
        if ($payment_id === null || (is_array($payment_id) && count($payment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id when calling subscriptionDocumentUpload'
            );
        }

        // verify the required parameter 'file' is set
        if ($file === null || (is_array($file) && count($file) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file when calling subscriptionDocumentUpload'
            );
        }

        // verify the required parameter 'payment_id2' is set
        if ($payment_id2 === null || (is_array($payment_id2) && count($payment_id2) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_id2 when calling subscriptionDocumentUpload'
            );
        }

        // verify the required parameter 'action' is set
        if ($action === null || (is_array($action) && count($action) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $action when calling subscriptionDocumentUpload'
            );
        }




        $resourcePath = '/subscriptions/pay/documents/{payment_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }

        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'payment_id' . '}',
                ObjectSerializer::toPathValue($payment_id),
                $resourcePath
            );
        }

        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($payment_id2 !== null) {
            $formParams['payment_id'] = ObjectSerializer::toFormValue($payment_id2);
        }
        // form params
        if ($action !== null) {
            $formParams['action'] = ObjectSerializer::toFormValue($action);
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function SubscriptionEligibility($x_api_version, $subscription_eligibility_request, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."SubscriptionEligibility",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['subscriptionEligibility'][0];
        $request = $this->subscriptionEligibilityRequest($x_api_version, $subscription_eligibility_request, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\SubscriptionEligibilityResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\SubscriptionEligibilityResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\SubscriptionEligibilityResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\SubscriptionEligibilityResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\SubscriptionEligibilityResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\BadRequestError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\AuthenticationError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\IdempotencyError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\RateLimitError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Cashfree\Model\ApiError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    public function subscriptionEligibilityRequest($x_api_version, $subscription_eligibility_request, $x_request_id = null, $x_idempotency_key = null, string $contentType = self::contentTypes['subscriptionEligibility'][0])
    {

        // verify the required parameter 'x_api_version' is set
        if ($x_api_version === null || (is_array($x_api_version) && count($x_api_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_api_version when calling subscriptionEligibility'
            );
        }

        // verify the required parameter 'subscription_eligibility_request' is set
        if ($subscription_eligibility_request === null || (is_array($subscription_eligibility_request) && count($subscription_eligibility_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_eligibility_request when calling subscriptionEligibility'
            );
        }




        $resourcePath = '/subscriptions/eligibility/payment_methods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        $headers['x-sdk-platform'] = "phpsdk-4.2.3";
        if (Cashfree::$XPartnerApiKey !== null) {
            $headers['x-partner-apikey'] = Cashfree::$XPartnerApiKey;
        }

        if (Cashfree::$XClientSecret !== null) {
            $headers['x-client-secret'] = Cashfree::$XClientSecret;
        }

        if (Cashfree::$XPartnerMerchantId !== null) {
            $headers['x-partner-merchantid'] = Cashfree::$XPartnerMerchantId;
        }

        if (Cashfree::$XClientId !== null) {
            $headers['x-client-id'] = Cashfree::$XClientId;
        }

        if (Cashfree::$XClientSignature !== null) {
            $headers['x-client-signature'] = Cashfree::$XClientSignature;
        }

        $headers['x-api-version'] = $x_api_version;
        if($x_request_id !== null) {
            $headers['x-request-id'] = $x_request_id;
        }

  //      if($x_idempotency_key !== null) {
 //           $headers['x-idempotency-key'] = $x_idempotency_key;
//        }



        // for model (json/xml)
        if (isset($subscription_eligibility_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($subscription_eligibility_request));
            } else {
                $httpBody = $subscription_eligibility_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = "https://sandbox.cashfree.com/pg";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $operationHost = "https://api.cashfree.com/pg";
        }
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }


    public function PGCustomerDeleteInstrument($x_api_version, $customer_id, $instrument_id, $x_request_id = null, $x_idempotency_key = null, GuzzleHttp\Client $http_client = null)
    {

        $env = "sandbox";
        if(Cashfree::$XEnvironment == Cashfree::$PRODUCTION) {
            $env = "production";
        }
        if(Cashfree::$XEnableErrorAnalytics) {
            \Sentry\init([
                'dsn' => 'https://f694e61bc6394e80bd2f687a4249a204@o330525.ingest.sentry.io/4505248768327680',
                'environment' => $env."PGCustomerDeleteInstrument",
                'attach_stacktrace' => true,
                'release' => '4.2.3',
                'traces_sample_rate' => 1.0,
                'before_send' => function (\Sentry\Event $event): ?\Sentry\Event {
                    $cashfreepg = "cashfree-pg";
                    if (count($event->getExceptions()) > 0 && count($event->getExceptions()[0]->getStackTrace()->getFrames()) > 0) {
                    if (strpos($event->getExceptions()[0]->getStackTrace()->getFrames()[0]->getFile(), $cashfreepg) !== false) {
                        $osContext = $event->getOsContext();
                        $osContext->setKernelVersion("");
                        $osContext->setMachineType("");
                        $osContext->setKernelVersion("");
                        $osContext->setVersion("");
                        $event->setOsContext($osContext);
                        if(Cashfree::$XEnableErrorAnalytics) {
                            return $event;
                        }
                        return null;
                    }
                    }
                return null;
                },
            ]);
        }

        $this->client = new Client();
        if($http_client !== null) {
            $this->client = $http_client;
        }
        $this->headerSelector = new HeaderSelector();
        $contentType = self::contentTypes['pGCustomerDeleteInstrument'][0];
        $request = $this->pGCustomerDeleteInstrumentRequest($x_api_version, $customer_id, $instrument_id, $x_request_id, $x_idempotency_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Cashfree\Model\InstrumentEntity' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\InstrumentEntity' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\InstrumentEntity', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Cashfree\Model\BadRequestError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\BadRequestError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\BadRequestError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Cashfree\Model\AuthenticationError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\AuthenticationError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\AuthenticationError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Cashfree\Model\ApiError404' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError404' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError404', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Cashfree\Model\ApiError409' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError409' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError409', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 422:
                    if ('\Cashfree\Model\IdempotencyError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\IdempotencyError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\IdempotencyError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 429:
                    if ('\Cashfree\Model\RateLimitError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\RateLimitError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\RateLimitError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Cashfree\Model\ApiError' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 502:
                    if ('\Cashfree\Model\ApiError502' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Cashfree\Model\ApiError502' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Cashfree\Model\ApiError502', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Cashfree\Model\InstrumentEntity';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
          