-- --------------------------------------------------------

--
-- Table structure for table `currency_exchange_rate`
--

DROP TABLE IF EXISTS `currency_exchange_rate`;
CREATE TABLE `currency_exchange_rate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(250) NOT NULL,
  `country_code` varchar(10) NOT NULL,
  `iso2_country_code` varchar(2) NOT NULL,
  `currency_code` varchar(10) NOT NULL,
  `currency_symbol` varchar(25) NOT NULL,
  `currency_name` varchar(250) NOT NULL,
  `exchange_rate` varchar(20) NOT NULL,
  `exchange_rate_static` varchar(20) NOT NULL,
  `status` enum('Active','InActive') NOT NULL DEFAULT 'Active',
  `paypal_supported` enum('Yes','No') NOT NULL DEFAULT 'No',
  `display_currency` enum('Yes','No') NOT NULL DEFAULT 'No',
  `country_name_chinese` varchar(255) NOT NULL,
  `china_post_group` enum('0','1','2','3','4') NOT NULL DEFAULT '0' COMMENT '0-Unknown Group,1-First group, 2-Second Group, 3-Third Group,4-Fourth Group',
  `geo_location_id` int(11) DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `capital` varchar(225) NOT NULL,
  `zip_code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Ind_country_code` (`country_code`),
  KEY `Ind_country` (`country`),
  KEY `Ind_country_id` (`country`,`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


INSERT INTO `currency_exchange_rate` (`id`, `country`, `country_code`, `iso2_country_code`, `currency_code`, `currency_symbol`, `currency_name`, `exchange_rate`, `exchange_rate_static`, `status`, `paypal_supported`, `display_currency`, `country_name_chinese`, `china_post_group`, `geo_location_id`, `zone_id`, `capital`, `zip_code`) VALUES
(1, 'United Arab Emirates', 'ARE', 'AR', 'AED', '', 'United Arab Emirates Dirham', '3.672688', '', 'Active', 'No', 'No', '阿联酋', '2', 1, 8, 'Abu Dhabi', '34657'),
(2, 'Afghanistan', 'AFG', 'AF', 'AFN', '', 'Afghan Afghani', '48.181299', '', 'Active', 'No', 'No', '阿富汗', '2', 1, 10, 'Kabul', '1053'),
(3, 'Albania', 'ALB', 'AL', 'ALL', '', 'Albanian Lek', '109.734999', '', 'Active', 'No', 'No', '阿尔巴尼亚', '3', 2, 10, 'Tirana', '1031'),
(4, 'Armenia', 'ARM', 'AM', 'AMD', '', 'Armenian Dram', '410.544995', '', 'Active', 'No', 'No', '亚美尼亚', '3', 1, 10, 'Yerevan', '0001'),
(5, 'Netherlands Antilles', 'ANT', 'AN', 'ANG', '', 'Netherlands Antillean Guilder', '1.7738', '', 'Active', 'No', 'No', '', '0', 5, 10, 'Willemstad', '4797'),
(6, 'Angola', 'AGO', 'AO', 'AOA', '', 'Angolan Kwanza', '95.489998', '', 'Active', 'No', 'No', '安哥拉', '4', 3, 10, 'Luanda', '2177'),
(7, 'Argentina', 'ARG', 'AR', 'ARS', '', 'Argentine Peso', '4.615274', '', 'Active', 'No', 'No', '阿根廷', '4', 5, 8, 'Buenos Aires', '2600'),
(8, 'Australia', 'AUS', 'AU', 'AUD', '$', 'Australian Dollar', '1.146492', '', 'Active', 'No', 'No', '澳大利亚', '3', 4, 4, 'Canberra', '2600'),
(9, 'Christmas Island', 'CXR', 'CX', 'AUD', '', 'Australian Dollar', '0.953657', '', 'Active', 'No', 'No', '圣诞岛', '0', 1, 10, 'The Settlement', '76108'),
(10, 'Cocos (Keeling) Islands', 'CCK', 'CC', 'AUD', '', 'Australian Dollar', '0.953657', '', 'Active', 'No', 'No', '科科斯群岛', '0', 1, 10, 'West Island', '6799'),
(11, 'Heard Island and McDonald Islands', 'HMD', 'HM', 'AUD', '', 'Australian Dollar', '0.953657', '', 'Active', 'No', 'No', '', '0', 7, 10, '', '0'),
(12, 'Kiribati', 'KIR', 'KI', 'AUD', '', 'Australian Dollar', '0.953657', '', 'Active', 'No', 'No', '基里巴斯', '4', 4, 10, 'Tarawa', '28543'),
(13, 'Nauru', 'NRU', 'NR', 'AUD', '', 'Australian Dollar', '0.953657', '', 'Active', 'No', 'No', '瑙鲁', '4', 4, 10, 'Yaren', '10770'),
(14, 'Norfolk Island', 'NFK', 'NF', 'AUD', '', 'Australian Dollar', '0.953657', '', 'Active', 'No', 'No', '诺福克岛', '0', 4, 10, 'Kingston', '2899'),
(15, 'Tuvalu', 'TUV', 'TV', 'AUD', '', 'Australian Dollar', '0.953657', '', 'Active', 'No', 'No', '图瓦卢', '4', 4, 10, 'Funafuti', '0'),
(16, 'Aruba', 'ABW', 'AW', 'AWG', '', 'Aruban Florin', '1.7901', '', 'Active', 'No', 'No', '阿鲁巴', '0', 5, 10, 'Oranjestad', '0000 AW'),
(17, 'Azerbaijan', 'AZE', 'AZ', 'AZN', '', 'Azerbaijani Manat', '0.7854', '', 'Active', 'No', 'No', '阿塞拜疆', '3', 1, 10, 'Baku', 'AZ1000'),
(18, 'Bosnia-Herzegovina', 'BIH', 'BA', 'BAM', '', 'Bosnia-Herzegovina Convertible Mark', '1.559625', '', 'Active', 'No', 'No', '波斯尼亚和黑塞哥维那', '3', 2, 10, 'Sarajevo', '71000'),
(19, 'Barbados', 'BRB', 'BB', 'BBD', '', 'Barbadian Dollar', '2', '', 'Active', 'No', 'No', '巴巴多斯', '4', 5, 10, 'Bridgetown', 'BB11118'),
(20, 'Bangladesh', 'BGD', 'BD', 'BDT', '', 'Bangladeshi Taka', '81.209433', '', 'Active', 'No', 'No', '孟加拉国', '2', 1, 7, 'Dhaka', '1206'),
(21, 'Bulgaria', 'BGR', 'BG', 'BGN', '', 'Bulgarian Lev', '1.558388', '', 'Active', 'No', 'No', '保加利亚', '3', 2, 9, 'Sofia', '1000'),
(22, 'Bahrain', 'BHR', 'BH', 'BHD', '', 'Bahraini Dina', '0.376694', '', 'Active', 'No', 'No', '巴林', '2', 1, 9, 'Manama', '973'),
(23, 'Burundi', 'BDI', 'BI', 'BIF', '', 'Burundian Franc', '1434.126667', '', 'Active', 'No', 'No', '布隆迪', '4', 3, 10, 'Bujumbura', '2900'),
(24, 'Bermuda', 'BMU', 'BM', 'BMD', '', 'Bermudan Dollar', '1', '', 'Active', 'No', 'No', '百慕大群岛', '0', 5, 10, 'Hamilton', '45011'),
(25, 'Brunei Darussalam', 'BRN', 'BN', 'BND', '', 'Brunei Dollar', '1.244213', '', 'Active', 'No', 'No', '文莱', '2', 1, 1, 'Bandar Seri Begawan', 'BS8811'),
(26, 'Bolivia', 'BOL', 'BO', 'BOB', '', 'Bolivian Boliviano', '6.960804', '', 'Active', 'No', 'No', '玻利维亚', '4', 6, 10, 'Sucre', '31014'),
(27, 'Brazil', 'BRA', 'BR', 'BRL', 'R$', 'Brazilian Real', '2.607643', '', 'Active', 'No', 'No', '巴西', '4', 6, 8, 'Brasília', '70000'),
(28, 'Bahamas', 'BHS', 'BS', 'BSD', '', 'Bahamian Dollar', '1', '', 'Active', 'No', 'No', '巴哈马', '4', 5, 10, 'Nassau', '11935'),
(29, 'Bhutan', 'BTN', 'BT', 'BTN', '', 'Bhutanese Ngultrum', '51.295', '', 'Active', 'No', 'No', '不丹', '2', 1, 10, 'Thimphu', '11001'),
(30, 'Botswana', 'BWA', 'BW', 'BWP', '', 'Botswanan Pula', '7.694578', '', 'Active', 'No', 'No', '博茨瓦纳', '4', 3, 9, 'Gaborone', '01'),
(31, 'Belarus', 'BLR', 'BY', 'BYR', '', 'Belarusian Ruble', '8359.9', '', 'Active', 'No', 'No', '白俄罗斯', '3', 2, 8, 'Minsk', '220002'),
(32, 'Belize', 'BLZ', 'BZ', 'BZD', '', 'Belize Dollar', '1.88145', '', 'Active', 'No', 'No', '伯利兹', '4', 5, 10, 'Belmopan', '0'),
(33, 'Canada', 'CAN', 'CA', 'CAD', '$', 'Canadian Dollar', '1.128132', '', 'Active', 'No', 'No', '加拿大', '3', 5, 6, 'Ottawa', '61350'),
(34, 'Congo, Dem. Republic', 'COD', 'CD', 'CDF', '', 'Congolese Franc', '923.415161', '', 'Active', 'No', 'No', '刚果（金）', '4', 3, 10, 'Kinshasa', '1022'),
(35, 'Liechtenstein', 'LIE', 'LI', 'CHF', '', 'Swiss Franc', '0.957061', '', 'Active', 'No', 'No', '列支敦士登', '3', 2, 10, 'Vaduz', '9490'),
(36, 'Switzerland', 'CHE', 'CH', 'CHF', 'CHF', 'Swiss Franc', '0.962618', '', 'Active', 'No', 'No', '瑞士', '3', 2, 6, 'Berne', '3000'),
(37, 'Chile', 'CHL', 'CL', 'CLP', '', 'Chilean Peso', '481.812127', '', 'Active', 'No', 'No', '智利', '4', 6, 10, 'Santiago', '3311'),
(38, 'China', 'CHN', 'CN', 'CNY', '¥', 'Chinese Yuan Renminbi', '6.12722', '6.354264', 'Active', 'No', 'No', '', '2', 1, 10, 'Beijing', '100000'),
(39, 'Colombia', 'COL', 'CO', 'COP', '', 'Colombian Peso', '1812.72105', '', 'Active', 'No', 'No', '', '4', 6, 8, 'Bogotá', '11001'),
(40, 'Costa Rica', 'CRI', 'CR', 'CRC', '', 'Costa Rican Colon', '497.835031', '', 'Active', 'No', 'No', '哥斯达黎加', '4', 5, 10, 'San José', '95101'),
(41, 'Cuba', 'CUB', 'CU', 'CUP', '', 'Cuban Peso', '1', '', 'Active', 'No', 'No', '古巴', '4', 5, 8, 'Havana', '32333'),
(42, 'Cape Verde', 'CPV', 'CV', 'CVE', '', 'Cape Verdean Escudo', '88.679566', '', 'Active', 'No', 'No', '佛得角', '4', 3, 10, 'Praia', '7600'),
(43, 'Czech Rep.', 'CZE', 'CZ', 'CZK', 'Kč', 'Czech Republic Koruna', '22.1789', '', 'Active', 'No', 'No', '捷克', '3', 2, 10, 'Prague', '74864'),
(44, 'Djibouti', 'DJI', 'DJ', 'DJF', '', 'Djiboutian Franc', '177.753332', '', 'Active', 'No', 'No', '吉布提', '4', 3, 9, 'Djibouti', 'DJ07'),
(45, 'Denmark', 'DNK', 'DK', 'DKK', 'kr', 'Danish Krone', '5.964679', '', 'Active', 'No', 'No', '丹麦', '3', 2, 6, 'Copenhagen', '13626'),
(46, 'Faroe Islands', 'FRO', 'FO', 'DKK', '', 'Danish Krone', '5.934224', '', 'Active', 'No', 'No', '法罗群岛', '0', 2, 10, 'Tórshavn', 'FO-110'),
(47, 'Greenland', 'GRL', 'GL', 'DKK', '', 'Danish Krone', '5.934224', '', 'Active', 'No', 'No', '格陵兰岛', '0', 5, 10, 'Nuuk', '3900'),
(48, 'Dominican Republic', 'DOM', 'DO', 'DOP', '', 'Dominican Peso', '38.891081', '', 'Active', 'No', 'No', '多米尼加共和国', '4', 5, 10, 'Santo Domingo', '10404'),
(49, 'Algeria', 'DZA', 'DZ', 'DZD', '', 'Algerian Dinar', '80.414547', '', 'Active', 'No', 'No', '阿尔及利亚', '4', 3, 10, 'Algiers', '16101'),
(50, 'Egypt', 'EGY', 'EG', 'EGP', '', 'Egyptian Pound', '6.088136', '', 'Active', 'No', 'No', '埃及', '4', 3, 9, 'Cairo', '39827'),
(51, 'Ethiopia', 'ETH', 'ET', 'ETB', '', 'Ethiopian Birr', '17.894417', '', 'Active', 'No', 'No', '埃塞俄比亚', '4', 3, 9, 'Addis Ababa', '62212'),
(52, 'Andorra', 'AND', 'AD', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '安道尔', '3', 2, 10, 'Andorra la Vella', 'AD500'),
(53, 'Austria', 'AUT', 'AT', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '奥地利', '3', 2, 6, 'Vienna', '22180'),
(54, 'Belgium', 'BEL', 'BE', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '比利时', '3', 2, 6, 'Brussels', '1299 '),
(55, 'European Union', '', 'EU', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '', '0', 3, 10, '', '0'),
(56, 'Finland', 'FIN', 'FI', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '芬兰', '3', 2, 6, 'Helsinki', '00100'),
(57, 'France', 'FRA', 'FR', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '法国', '3', 2, 6, 'Paris', '75001'),
(58, 'French Guiana', 'GUF', 'GF', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '法属圭亚那', '0', 6, 10, 'Cayenne', '97300'),
(59, 'French Southern Territories', 'ATF', 'TF', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '', '0', 7, 10, 'Port-aux-Français', '0'),
(60, 'Germany', 'DEU', 'DE', 'EUR', '&euro;', 'Euro', '0.801641', '', 'Active', 'No', 'No', '德国', '3', 2, 6, 'Berlin', '3570'),
(61, 'Greece', 'GRC', 'GR', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '希腊', '3', 2, 6, 'Athens', '45701'),
(62, 'Guadeloupe (French)', 'GLP', 'GP', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '瓜德罗普岛', '0', 5, 10, 'Basse-Terre', '0'),
(63, 'Ireland', 'IRL', 'IE', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '爱尔兰', '3', 2, 6, 'Dublin', '94568'),
(64, 'Italy', 'ITA', 'IT', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '意大利', '3', 2, 6, 'Rome', '46784'),
(65, 'Luxembourg', 'LUX', 'LU', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '卢森堡', '3', 2, 6, 'Luxembourg', 'L-1009'),
(66, 'Martinique (French)', 'MTQ', 'MQ', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '马提尼克', '0', 5, 10, 'Fort-de-France', '97200'),
(67, 'Mayotte', 'MYT', 'YT', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '马约特', '4', 3, 10, 'Mamoutzou', '97600'),
(68, 'Monaco', 'MCO', 'MC', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '摩纳哥', '3', 2, 10, 'Monaco', '98000'),
(69, 'Montenegro', 'MNE', 'ME', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '黑山共和国', '3', 2, 10, 'Podgorica', '81000'),
(70, 'Netherlands', 'NLD', 'NL', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '荷兰', '3', 2, 10, 'Amsterdam', '1065'),
(71, 'Portugal', 'PRT', 'PT', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '葡萄牙', '3', 2, 6, 'Lisbon', '52253'),
(72, 'Reunion (French)', 'REU', 'RE', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '留尼汪', '4', 3, 10, 'Saint-Denis', '93210'),
(73, 'Saint Pierre and Miquelon', 'SPM', 'PM', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '圣皮埃尔和密克隆', '0', 5, 10, 'Saint-Pierre', '97500'),
(74, 'Spain', 'ESP', 'ES', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '西班牙', '3', 2, 6, 'Madrid', '50156'),
(75, 'Vatican', 'VAT', 'VA', 'EUR', '', 'Euro', '0.796577', '', 'Active', 'No', 'No', '梵蒂冈', '3', 2, 10, 'Vatican', '120'),
(76, 'Fiji', 'FJI', 'FJ', 'FJD', '', 'Fijian Dollar', '1.77025', '', 'Active', 'No', 'No', '斐济', '4', 4, 10, 'Suva', '1252'),
(77, 'Falkland Islands', 'FLK', 'FK', 'FKP', '', 'Falkland Islands Pound', '0.629755', '', 'Active', 'No', 'No', '', '0', 6, 10, 'Stanley', '28164'),
(78, 'Great Britain', 'GBR', 'GB', 'GBP', '£', 'British Pound Sterling', '0.638797', '', 'Active', 'No', 'No', '英国', '0', 2, 10, '', '0'),
(79, 'Guernsey', 'GGY', 'GG', 'GBP', '', 'British Pound Sterling', '0.629755', '', 'Active', 'No', 'No', '', '0', 2, 10, 'St Peter Port', 'GY1'),
(80, 'Isle of Man', 'IMN', 'IM', 'GBP', '', 'British Pound Sterling', '0.629755', '', 'Active', 'No', 'No', '', '0', 2, 10, 'Douglas', '85607'),
(81, 'Jersey', 'JEY', 'JE', 'GBP', '', 'British Pound Sterling', '0.629755', '', 'Active', 'No', 'No', '', '0', 2, 10, 'Saint Helier', 'JE2'),
(82, 'South Georgia & South Sandwich Islands', 'SGS', 'GS', 'GBP', '', 'British Pound Sterling', '0.629755', '', 'Active', 'No', 'No', '', '0', 7, 10, 'Grytviken', '0'),
(83, 'United Kingdom', 'GBR', 'GB', 'GBP', '', 'British Pound Sterling', '0.629755', '', 'Active', 'No', 'No', '', '3', 2, 10, 'London', '6320'),
(84, 'Georgia', 'GEO', 'GE', 'GEL', '', 'Georgian Lari', '1.726683', '', 'Active', 'No', 'No', '格鲁吉亚', '3', 2, 10, 'Tbilisi', '179'),
(85, 'Ghana', 'GHA', 'GH', 'GHS', '', 'Ghanaian Cedi', '1.931433', '', 'Active', 'No', 'No', '加纳', '4', 3, 9, 'Accra', '00233'),
(86, 'Gibraltar', 'GIB', 'GI', 'GIP', '', 'Gibraltar Pound', '0.62767', '', 'Active', 'No', 'No', '直布罗陀', '0', 2, 10, 'Gibraltar', '48173'),
(87, 'Gambia', 'GMB', 'GM', 'GMD', '', 'Gambian Dalasi', '31.881101', '', 'Active', 'No', 'No', '冈比亚', '4', 3, 10, 'Banjul', '0'),
(88, 'Guinea', 'GIN', 'GN', 'GNF', '', 'Guinean Franc', '7156.966667', '', 'Active', 'No', 'No', '几内亚', '4', 4, 9, 'Conakry', '2984'),
(89, 'Guatemala', 'GTM', 'GT', 'GTQ', '', 'Guatemalan Quetzal', '7.829517', '', 'Active', 'No', 'No', '危地马拉', '4', 5, 10, 'Guatemala City', 'GT01'),
(90, 'Guyana', 'GUY', 'GY', 'GYD', '', 'Guyanaese Dollar', '202.949998', '', 'Active', 'No', 'No', '圭亚那', '4', 6, 8, 'Georgetown', '78626'),
(91, 'Hong Kong', 'HKG', 'HK', 'HKD', '$', 'Hong Kong Dollar', '7.754703', '', 'Active', 'No', 'No', '香港', '0', 1, 1, 'Hong Kong', '999077'),
(92, 'Honduras', 'HND', 'HN', 'HNL', '', 'Honduran Lempira', '19.46019', '', 'Active', 'No', 'No', '洪都拉斯', '4', 5, 10, 'Tegucigalpa', '11101'),
(93, 'Croatia', 'HRV', 'HR', 'HRK', '', 'Croatian Kuna', '5.969697', '', 'Active', 'No', 'No', '克罗地亚', '3', 2, 9, 'Zagreb', '10020'),
(94, 'Haiti', 'HTI', 'HT', 'HTG', '', 'Haitian Gourde', '41.8571', '', 'Active', 'No', 'No', '海地', '4', 5, 10, 'Port-au-Prince', 'HT 613'),
(95, 'Hungary', 'HUN', 'HU', 'HUF', 'Ft', 'Hungarian Forint', '245.534701', '', 'Active', 'No', 'No', '匈牙利', '3', 2, 8, 'Budapest', '1051'),
(96, 'Indonesia', 'IDN', 'ID', 'IDR', '', 'Indonesian Rupiah', '9500.42738', '', 'Active', 'No', 'No', '印度尼西亚', '2', 1, 3, 'Jakarta', '13420'),
(97, 'Israel', 'ISR', 'IL', 'ILS', '₪', 'Israeli New Sheqel', '3.825039', '', 'Active', 'No', 'No', '以色列', '2', 1, 8, 'Jerusalem', '91000'),
(98, 'India', 'IND', 'IN', 'INR', 'Rs', 'Indian Rupee', '61.8061', '', 'Active', 'No', 'No', '印度', '2', 1, 7, 'New Delhi', '110001'),
(99, 'Iraq', 'IRQ', 'IQ', 'IQD', '', 'Iraqi Dinar', '1158.33', '', 'Active', 'No', 'No', '伊拉克', '2', 1, 10, 'Baghdad', '31014'),
(100, 'Iran', 'IRN', 'IR', 'IRR', '', 'Iranian Rial', '12223.726667', '', 'Active', 'No', 'No', '伊朗', '2', 1, 9, 'Tehran', '14174'),
(101, 'Iceland', 'ISL', 'IS', 'ISK', '', 'Icelandic Krona', '118.62', '', 'Active', 'No', 'No', '冰岛', '3', 2, 10, 'Reykjavik', '150'),
(102, 'Jamaica', 'JAM', 'JM', 'JMD', '', 'Jamaican Dollar', '88.8657', '', 'Active', 'No', 'No', '牙买加', '4', 5, 10, 'Kingston', 'JMAKN01'),
(103, 'Jordan', 'JOR', 'JO', 'JOD', '', 'Jordanian Dinar', '0.70849', '', 'Active', 'No', 'No', '约旦', '2', 1, 8, 'Amman', '11110'),
(104, 'Japan', 'JPN', 'JP', 'JPY', '¥', 'Japanese Yen', '116.5026', '', 'Active', 'No', 'No', '日本', '1', 1, 6, 'Tokyo', '100-0001'),
(105, 'Kenya', 'KEN', 'KE', 'KES', '', 'Kenyan Shilling', '83.983915', '', 'Active', 'No', 'No', '肯尼亚', '4', 3, 9, 'Nairobi', '100'),
(106, 'Kyrgyzstan', 'KGZ', 'KG', 'KGS', '', 'Kyrgystani Som', '44.952151', '', 'Active', 'No', 'No', '吉尔吉斯斯坦', '2', 1, 10, 'Bishkek', '720001'),
(107, 'Cambodia', 'KHM', 'KH', 'KHR', '', 'Cambodian Riel', '4052.19', '', 'Active', 'No', 'No', '柬埔寨', '2', 1, 3, 'Phnom Penh', '12000'),
(108, 'Comoros', 'COM', 'KM', 'KMF', '', 'Comorian Franc', '396.545429', '', 'Active', 'No', 'No', '科摩罗群岛', '4', 5, 10, 'Moroni', '84646'),
(109, 'Korea-North', 'PRK', 'KP', 'KPW', '', 'North Korean Won', '900', '', 'Active', 'No', 'No', '朝鲜', '1', 1, 10, 'Pyongyang', '48458'),
(110, 'Korea-South', 'KOR', 'KR', 'KRW', '', 'South Korean Won', '1130.495862', '', 'Active', 'No', 'No', '韩国', '1', 1, 10, 'Seoul', '100860'),
(111, 'Kuwait', 'KWT', 'KW', 'KWD', '', 'Kuwaiti Dinar', '0.281952', '', 'Active', 'No', 'No', '科威特', '2', 1, 9, 'Kuwait City', '13060'),
(112, 'Kazakhstan', 'KAZ', 'KZ', 'KZT', '', 'Kazakhstani Tenge', '148.486876', '', 'Active', 'No', 'No', '哈萨克斯坦', '1', 1, 9, 'Astana', '10000'),
(113, 'Laos', 'LAO', 'LA', 'LAK', '', 'Laotian Kip', '7982.166667', '', 'Active', 'No', 'No', '老挝', '2', 1, 10, 'Vientiane', '01000'),
(114, 'Lebanon', 'LBN', 'LB', 'LBP', '', 'Lebanese Pound', '1500.418525', '', 'Active', 'No', 'No', '黎巴嫩', '2', 1, 10, 'Beirut', '1100'),
(115, 'Sri Lanka', 'LKA', 'LK', 'LKR', '', 'Sri Lankan Rupee', '132.321911', '', 'Active', 'No', 'No', '斯里兰卡', '2', 1, 7, 'Colombo', '300'),
(116, 'Liberia', 'LBR', 'LR', 'LRD', '', 'Liberian Dollar', '74.1125', '', 'Active', 'No', 'No', '利比里亚', '4', 3, 10, 'Monrovia', '91016'),
(117, 'Lesotho', 'LSO', 'LS', 'LSL', '', 'Lesotho Loti', '8.259983', '', 'Active', 'No', 'No', '莱索托', '4', 3, 10, 'Maseru', '500'),
(118, 'Lithuania', 'LTU', 'LT', 'LTL', '', 'Lithuanian Litas', '2.750449', '', 'Active', 'No', 'No', '立陶宛', '3', 2, 10, 'Vilnius', '04001'),
(119, 'Latvia', 'LVA', 'LV', 'LVL', '', 'Latvian Lats', '0.554573', '', 'Active', 'No', 'No', '拉脱维亚', '3', 2, 9, 'Riga', 'LV-1001'),
(120, 'Libya', 'LBY', 'LY', 'LYD', '', 'Libyan Dinar', '1.256817', '', 'Active', 'No', 'No', '利比亚', '4', 3, 10, 'Tripoli', '50676'),
(121, 'Morocco', 'MAR', 'MA', 'MAD', '', 'Moroccan Dirham', '8.801646', '', 'Active', 'No', 'No', '摩洛哥', '4', 3, 9, 'Rabat', '11110'),
(122, 'Western Sahara', 'ESH', 'EH', 'MAD', '', 'Moroccan Dirham', '8.801646', '', 'Active', 'No', 'No', '', '0', 3, 10, 'El Aaiún', '0'),
(123, 'Moldova', 'MDA', 'MD', 'MDL', '', 'Moldovan Leu', '12.436819', '', 'Active', 'No', 'No', '摩尔多瓦', '3', 2, 10, 'Chişinău', '2068'),
(124, 'Madagascar', 'MDG', 'MG', 'MGA', '', 'Malagasy Ariary', '2228.966667', '', 'Active', 'No', 'No', '马达加斯加', '4', 3, 9, 'Antananarivo', '101'),
(125, 'Macedonia', 'MKD', 'MK', 'MKD', '', 'Macedonian Denar', '49.998625', '', 'Active', 'No', 'No', '马其顿', '3', 2, 10, 'Skopje', '1040'),
(126, 'Myanmar', 'MMR', 'MM', 'MMK', '', 'Myanma Kyat', '871.705', '', 'Active', 'No', 'No', '缅甸', '2', 1, 10, 'Nay Pyi Taw', '87'),
(127, 'Mongolia', 'MNG', 'MN', 'MNT', '', 'Mongolian Tugrik', '1397.929993', '', 'Active', 'No', 'No', '蒙古', '1', 1, 3, 'Ulan Bator', '11000'),
(128, 'Macau', 'MAC', 'MO', 'MOP', '', 'Macanese Pataca', '7.9522', '', 'Active', 'No', 'No', '', '0', 1, 1, '', '0'),
(129, 'Mauritania', 'MRT', 'MR', 'MRO', '', 'Mauritanian Ouguiya', '300.681667', '', 'Active', 'No', 'No', '毛里塔尼亚', '4', 3, 10, 'Nouakchott', '222'),
(130, 'Mauritius', 'MUS', 'MU', 'MUR', '', 'Mauritian Rupee', '30.411164', '', 'Active', 'No', 'No', '毛里求斯', '4', 3, 10, 'Port Louis', '56290'),
(131, 'Maldives', 'MDV', 'MV', 'MVR', '', 'Maldivian Rufiyaa', '15.334333', '', 'Active', 'No', 'No', '马尔代夫', '2', 1, 10, 'Malé', '20012'),
(132, 'Malawi', 'MWI', 'MW', 'MWK', '', 'Malawian Kwacha', '273.352508', '', 'Active', 'No', 'No', '马拉维', '4', 3, 10, 'Lilongwe', '30500'),
(133, 'Mexico', 'MEX', 'MX', 'MXN', '$', 'Mexican Peso', '13.57504', '', 'Active', 'No', 'No', '墨西哥', '4', 5, 8, 'Mexico City', '65265'),
(134, 'Malaysia', 'MYS', 'MY', 'MYR', 'RM', 'Malaysian Ringgit', '3.351279', '', 'Active', 'No', 'No', '马来西亚', '2', 1, 3, 'Kuala Lumpur', '50000'),
(135, 'Mozambique', 'MOZ', 'MZ', 'MZN', '', 'Mozambican Metical', '28.50875', '', 'Active', 'No', 'No', '莫桑比克', '4', 3, 9, 'Maputo', '1100'),
(136, 'Namibia', 'NAM', 'NA', 'NAD', '', 'Namibian Dollar', '8.255996', '', 'Active', 'No', 'No', '纳米比亚', '4', 3, 10, 'Windhoek', '9000'),
(137, 'Nigeria', 'NGA', 'NG', 'NGN', '', 'Nigerian Naira', '157.304594', '', 'Active', 'No', 'No', '尼日利亚', '4', 3, 9, 'Abuja', '905101'),
(138, 'Nicaragua', 'NIC', 'NI', 'NIO', '', 'Nicaraguan Cordoba', '23.626742', '', 'Active', 'No', 'No', '尼加拉瓜', '4', 5, 10, 'Managua', '4141'),
(139, 'Bouvet Island', 'BVT', 'BV', 'NOK', '', 'Norwegian Krone', '5.854828', '', 'Active', 'No', 'No', '', '0', 7, 10, '', '0'),
(140, 'Norway', 'NOR', 'NO', 'NOK', 'kr', 'Norwegian Krone', '6.774207', '', 'Active', 'No', 'No', '挪威', '3', 2, 10, 'Oslo', '56744'),
(141, 'Svalbard and Jan Mayen Islands', 'SJM', 'SJ', 'NOK', '', 'Norwegian Krone', '5.854828', '', 'Active', 'No', 'No', '', '0', 7, 10, 'Longyearbyen', '9170'),
(142, 'Nepal', 'NPL', 'NP', 'NPR', '', 'Nepalese Rupee', '88.11028', '', 'Active', 'No', 'No', '尼泊尔', '2', 1, 7, 'Kathmandu', '44600'),
(143, 'Cook Islands', 'COK', 'CK', 'NZD', '', 'New Zealand Dollar', '1.224302', '', 'Active', 'No', 'No', '库克群岛', '0', 4, 10, 'Avarua', '4035715'),
(144, 'New Zealand', 'NZL', 'NZ', 'NZD', '$', 'New Zealand Dollar', '1.259583', '', 'Active', 'No', 'No', '新西兰', '3', 4, 4, 'Wellington', '44090'),
(145, 'Niue', 'NIU', 'NU', 'NZD', '', 'New Zealand Dollar', '1.224302', '', 'Active', 'No', 'No', '', '0', 4, 10, 'Alofi', '0'),
(146, 'Pitcairn Island', 'PCN', 'PN', 'NZD', '', 'New Zealand Dollar', '1.224302', '', 'Active', 'No', 'No', '', '0', 4, 10, 'Adamstown', '19501'),
(147, 'Tokelau', 'TKL', 'TK', 'NZD', '', 'New Zealand Dollar', '1.224302', '', 'Active', 'No', 'No', '', '0', 4, 10, 'Nukunonu', '0'),
(148, 'Oman', 'OMN', 'OM', 'OMR', '', 'Omani Rial', '0.384812', '', 'Active', 'No', 'No', '阿曼', '2', 1, 9, 'Muscat', '113'),
(149, 'Panama', 'PAN', 'PA', 'PAB', '', 'Panamanian Balboa', '1', '', 'Active', 'No', 'No', '巴拿马', '4', 5, 8, 'Panama City', '32401'),
(150, 'Peru', 'PER', 'PE', 'PEN', '', 'Peruvian Nuevo Sol', '2.603013', '', 'Active', 'No', 'No', '秘鲁', '4', 6, 8, 'Lima', '45801'),
(151, 'Papua New Guinea', 'PNG', 'PG', 'PGK', '', 'Papua New Guinean Kina', '2.054549', '', 'Active', 'No', 'No', '巴布亚新几内亚', '4', 4, 4, 'Port Moresby', '121'),
(152, 'Philippines', 'PHL', 'PH', 'PHP', '₱', 'Philippine Peso', '44.9356', '', 'Active', 'No', 'No', '菲律宾', '2', 1, 3, 'Manila', '1000'),
(153, 'Pakistan', 'PAK', 'PK', 'PKR', '', 'Pakistani Rupee', '101.9444', '94.023294', 'Active', 'No', 'No', '巴基斯坦', '2', 1, 7, 'Islamabad', '74700'),
(154, 'Poland', 'POL', 'PL', 'PLN', 'zł', 'Polish Zloty', '3.382951', '', 'Active', 'No', 'No', '波兰', '3', 2, 8, 'Warsaw', '46580'),
(155, 'Paraguay', 'PRY', 'PY', 'PYG', '', 'Paraguayan Guarani', '4410.84861', '', 'Active', 'No', 'No', '巴拉圭', '4', 6, 10, 'Asunción', '1719'),
(156, 'Qatar', 'QAT', 'QA', 'QAR', '', 'Qatari Rial', '3.640912', '', 'Active', 'No', 'No', '卡塔尔', '2', 1, 9, 'Doha', '00974'),
(157, 'Romania', 'ROU', 'RO', 'RON', '', 'Romanian Leu', '3.577474', '', 'Active', 'No', 'No', '罗马尼亚', '0', 2, 9, 'Bucharest', '013681'),
(158, 'Serbia', 'SRB', 'RS', 'RSD', '', 'Serbian Dinar', '93.726442', '', 'Active', 'No', 'No', '塞尔维亚', '3', 2, 10, 'Belgrade', '59714'),
(159, 'Russia', 'RUS', 'RU', 'RUB', '', 'Russian Ruble', '31.697677', '', 'Active', 'No', 'No', '俄罗斯', '2', 1, 5, 'Moscow', '83843'),
(160, 'Rwanda', 'RWA', 'RW', 'RWF', '', 'Rwandan Franc', '609.539388', '', 'Active', 'No', 'No', '卢旺达', '4', 3, 9, 'Kigali', '010201'),
(161, 'Saudi Arabia', 'SAU', 'SA', 'SAR', '', 'Saudi Riyal', '3.750176', '', 'Active', 'No', 'No', '沙特阿拉伯', '2', 1, 9, 'Riyadh', '11495'),
(162, 'Solomon Islands', 'SLB', 'SB', 'SBD', '', 'Solomon Islands Dollar', '7.065961', '', 'Active', 'No', 'No', '所罗门群岛', '4', 4, 10, 'Honiara', '1925'),
(163, 'Seychelles', 'SYC', 'SC', 'SCR', '', 'Seychellois Rupee', '13.040057', '', 'Active', 'No', 'No', '塞舌尔', '4', 3, 10, 'Victoria', '361'),
(164, 'Sudan', 'SDN', 'SD', 'SDG', '', 'Sudanese Pound', '4.4152', '', 'Active', 'No', 'No', '苏丹', '4', 3, 10, 'Khartoum', '11111'),
(165, 'Sweden', 'SWE', 'SE', 'SEK', 'kr', 'Swedish Krona', '7.416207', '', 'Active', 'No', 'No', '瑞典', '3', 2, 6, 'Stockholm', '189852'),
(166, 'Singapore', 'SGP', 'SG', 'SGD', '$', 'Singapore Dollar', '1.297386', '', 'Active', 'No', 'No', '新加坡', '2', 1, 3, 'Singapore', '247964'),
(167, 'Saint Helena', 'SHN', 'SH', 'SHP', '', 'Saint Helena Pound', '0.629755', '', 'Active', 'No', 'No', '', '0', 3, 10, 'Jamestown', '14701'),
(168, 'Sierra Leone', 'SLE', 'SL', 'SLL', '', 'Sierra Leonean Leone', '4361.775363', '', 'Active', 'No', 'No', '塞拉利昂', '4', 3, 10, 'Freetown', '02702'),
(169, 'Somalia', 'SOM', 'SO', 'SOS', '', 'Somali Shilling', '1617.456667', '', 'Active', 'No', 'No', '索马里', '4', 3, 10, 'Mogadishu', '252'),
(170, 'Suriname', 'SUR', 'SR', 'SRD', '', 'Surinamese Dollar', '3.275', '', 'Active', 'No', 'No', '苏里南', '4', 6, 10, 'Paramaribo', '0'),
(171, 'Sao Tome and Principe', 'STP', 'ST', 'STD', '', 'Sao Tomé and Príncipe Dobra', '20072.246667', '', 'Active', 'No', 'No', '圣多美和普林西比', '4', 3, 10, 'São Tomé', '2001'),
(172, 'El Salvador', 'SLV', 'SV', 'SVC', '', 'Salvadoran Colon', '8.71802', '', 'Active', 'No', 'No', '萨尔瓦多', '4', 5, 10, 'San Salvador', 'CP 1101'),
(173, 'Syria', 'SYR', 'SY', 'SYP', '', 'Syrian Pound', '65.246168', '', 'Active', 'No', 'No', '叙利亚', '2', 1, 10, 'Damascus', '97089'),
(174, 'Swaziland', 'SWZ', 'SZ', 'SZL', '', 'Swazi Lilangeni', '8.261117', '', 'Active', 'No', 'No', '斯威士兰', '4', 3, 10, 'Mbabane', 'H100'),
(175, 'Thailand', 'THA', 'TH', 'THB', '฿', 'Thai Baht', '32.78137', '', 'Active', 'No', 'No', '泰国', '2', 1, 3, 'Bangkok', '390019'),
(176, 'Tajikistan', 'TJK', 'TJ', 'TJS', '', 'Tajikistani Somoni', '4.5819', '', 'Active', 'No', 'No', '塔吉克斯坦', '1', 1, 10, 'Dushanbe', 'TI04'),
(177, 'Turkmenistan', 'TKM', 'TM', 'TMT', '', 'Turkmenistani Manat', '2.8503', '', 'Active', 'No', 'No', '土库曼斯坦', '1', 1, 10, 'Ashgabat', '744000'),
(178, 'Tunisia', 'TUN', 'TN', 'TND', '', 'Tunisian Dinar', '1.596925', '', 'Active', 'No', 'No', '突尼斯', '4', 3, 9, 'Tunis', 'P0N 1J0'),
(179, 'Tonga', 'TON', 'TO', 'TOP', '', 'Tongan Pa''anga', '1.751448', '', 'Active', 'No', 'No', '汤加', '4', 4, 10, 'Nuku\\''alofa', '910'),
(180, 'Turkey', 'TUR', 'TR', 'TRY', '', 'Turkish Lira', '1.795137', '', 'Active', 'No', 'No', '土耳其', '2', 1, 7, 'Ankara', '06000'),
(181, 'Trinidad and Tobago', 'TTO', 'TT', 'TTD', '', 'Trinidad and Tobago Dollar', '6.376663', '', 'Active', 'No', 'No', '特立尼达和多巴哥', '4', 5, 10, 'Port of Spain', '120110'),
(182, 'Taiwan', 'TWN', 'TW', 'TWD', 'NT$', 'New Taiwan Dollar', '30.72682', '', 'Active', 'No', 'No', '台湾', '2', 1, 1, 'Taipei', '100'),
(183, 'Tanzania', 'TZA', 'TZ', 'TZS', '', 'Tanzanian Shilling', '1567.94676', '', 'Active', 'No', 'No', '坦桑尼亚', '4', 3, 10, 'Dodoma', '0105'),
(184, 'Ukraine', 'UKR', 'UA', 'UAH', '', 'Ukrainian Hryvnia', '8.074449', '', 'Active', 'No', 'No', '乌克兰', '3', 2, 8, 'Kyiv', '01032'),
(185, 'Uganda', 'UGA', 'UG', 'UGX', '', 'Ugandan Shilling', '2499.07562', '', 'Active', 'No', 'No', '乌干达', '4', 3, 9, 'Kampala', '7106'),
(186, 'American Samoa', 'ASM', 'AS', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '东萨摩亚（美属）', '0', 4, 10, 'Pago Pago', '96799'),
(187, 'British Indian Ocean Territory', 'IOT', 'IO', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '', '0', 3, 10, '', '0'),
(188, 'Guam (USA)', 'GUM', 'GU', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '关岛', '0', 4, 10, 'Hagåtña', '96910'),
(189, 'Marshall Islands', 'MHL', 'MH', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '马绍尔群岛', '4', 4, 10, 'Majuro', '96960'),
(190, 'Micronesia', 'FSM', 'FM', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '密克罗尼西亚联邦', '4', 4, 10, 'Palikir', '96799'),
(191, 'Northern Mariana Islands', 'MNP', 'MP', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '马里亚纳群岛', '0', 4, 10, 'Saipan', '96950'),
(192, 'Palau', 'PLW', 'PW', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '帕劳', '4', 4, 10, 'Melekeok - Palau State Capital', '96940'),
(193, 'Puerto Rico', 'PRI', 'PR', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '波多黎各', '0', 5, 10, 'San Juan', '00921'),
(194, 'Turks and Caicos Islands', 'TCA', 'TC', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '特克斯和凯科斯群岛', '0', 5, 10, 'Cockburn Town', '0'),
(195, 'United States', 'USA', 'US', 'USD', '$', 'United States Dollar', '1', '', 'Active', 'No', 'No', '美国', '3', 5, 10, 'Washington', '20004'),
(196, 'USA Minor Outlying Islands', 'UMI', 'UM', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '', '0', 5, 10, '', '0'),
(197, 'Virgin Islands (British)', 'VGB', 'VG', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '英属维尔京群岛', '0', 5, 10, 'Road Town', 'VG1110'),
(198, 'Virgin Islands (USA)', 'VIR', 'VI', 'USD', '', 'United States Dollar', '1', '', 'Active', 'No', 'No', '美属维尔京群岛', '0', 5, 10, 'Charlotte Amalie', '00804'),
(199, 'Uruguay', 'URY', 'UY', 'UYU', '', 'Uruguayan Peso', '21.227465', '', 'Active', 'No', 'No', '乌拉圭', '4', 6, 10, 'Montevideo', '56265'),
(200, 'Uzbekistan', 'UZB', 'UZ', 'UZS', '', 'Uzbekistan Som', '1909.388954', '', 'Active', 'No', 'No', '乌兹别克斯坦', '1', 1, 10, 'Tashkent', '100167'),
(201, 'Venezuela', 'VEN', 'VE', 'VEF', '', 'Venezuelan Bolívar', '4.294323', '', 'Active', 'No', 'No', '委内瑞拉', '4', 6, 10, 'Caracas', '1010-A'),
(202, 'Vietnam', 'VNM', 'VN', 'VND', '', 'Vietnamese Dong', '20808.845825', '', 'Active', 'No', 'No', '越南', '1', 1, 3, 'Hanoi', '10000'),
(203, 'Vanuatu', 'VUT', 'VU', 'VUV', '', 'Vanuatu Vatu', '91.25', '', 'Active', 'No', 'No', '瓦努阿图', '4', 4, 10, 'Port Vila', '00000'),
(204, 'Samoa', 'WSM', 'WS', 'WST', '', 'Samoan Tala', '2.309777', '', 'Active', 'No', 'No', '西萨摩亚', '4', 4, 10, 'Apia', '0'),
(205, 'Cameroon', 'CMR', 'CM', 'XAF', '', 'CFA Franc BEAC', '522.932787', '', 'Active', 'No', 'No', '喀麦隆', '4', 3, 10, 'Yaoundé', '00237'),
(206, 'Central African Republic', 'CAF', 'CF', 'XAF', '', 'CFA Franc BEAC', '522.932787', '', 'Active', 'No', 'No', '', '4', 3, 10, 'Bangui', 'R023'),
(207, 'Chad', 'TCD', 'TD', 'XAF', '', 'CFA Franc BEAC', '522.932787', '', 'Active', 'No', 'No', '乍得', '4', 3, 9, 'N\\''Djamena', '1146'),
(208, 'Congo', 'COG', 'CG', 'XAF', '', 'CFA Franc BEAC', '522.932787', '', 'Active', 'No', 'No', '刚果', '4', 3, 9, 'Brazzaville', '2314'),
(209, 'Equatorial Guinea', 'GNQ', 'GQ', 'XAF', '', 'CFA Franc BEAC', '522.932787', '', 'Active', 'No', 'No', '赤道几内亚', '4', 3, 10, 'Malabo', '3019'),
(210, 'Gabon', 'GAB', 'GA', 'XAF', '', 'CFA Franc BEAC', '522.932787', '', 'Active', 'No', 'No', '加蓬', '4', 3, 9, 'Libreville', '101'),
(211, 'Anguilla', 'AIA', 'AI', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '安圭拉', '0', 5, 10, 'The Valley', '36854'),
(212, 'Antarctica', 'ATA', 'AQ', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '', '0', 7, 10, 'chandra patel', '0'),
(213, 'Antigua and Barbuda', 'ATG', 'AG', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '安提瓜和巴布达', '4', 5, 10, 'St. John\\''s', '00831'),
(214, 'Dominica', 'DMA', 'DM', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '多米尼加共和国', '4', 5, 10, 'Roseau', '56751'),
(215, 'Grenada', 'GRD', 'GD', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '格林纳达', '4', 5, 10, 'St. George\\''s', '84770'),
(216, 'Montserrat\n', 'MSR', 'MS', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '蒙特塞拉特岛', '0', 5, 10, 'Plymouth', '55446'),
(217, 'Saint Kitts & Nevis Anguilla', 'KNA', 'KN', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '圣基茨和尼维斯', '4', 5, 10, 'Basseterre', '0'),
(218, 'Saint Lucia', 'LCA', 'LC', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '圣卢西亚岛', '4', 5, 10, 'Castries', '00124'),
(219, 'Saint Vincent & Grenadines', 'VCT', 'VC', 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'Active', 'No', 'No', '圣文森特', '4', 5, 10, 'Kingstown', 'VC0100'),
(220, 'International Monetary Fund (IMF)', '', '', 'XDR', '', 'Special Drawing Rights', '0.660259', '', 'Active', 'No', 'No', '', '0', 7, 10, '', '0'),
(221, 'Benin', 'BEN', 'BJ', 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'Active', 'No', 'No', '贝宁', '4', 3, 10, 'Porto-Novo', '00229'),
(222, 'Burkina Faso', 'BFA', 'BF', 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'Active', 'No', 'No', '布基纳法索', '4', 3, 9, 'Ouagadougou', '3'),
(223, 'Ivory Coast', 'CIV', 'CI', 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'Active', 'No', 'No', '', '0', 3, 10, 'Yamoussoukro', '00225'),
(224, 'Mali', 'MLI', 'ML', 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'Active', 'No', 'No', '马里', '4', 3, 9, 'Bamako', '91091'),
(225, 'Niger', 'NER', 'NE', 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'Active', 'No', 'No', '尼日尔', '4', 3, 9, 'Niamey', '8001'),
(226, 'Senegal', 'SEN', 'SN', 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'Active', 'No', 'No', '塞内加尔', '4', 3, 9, 'Dakar', '61641'),
(227, 'Togo', 'TGO', 'TG', 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'Active', 'No', 'No', '多哥', '4', 3, 10, 'Lomé', '00228'),
(228, 'New Caledonia (French)', 'NCL', 'NC', 'XPF', '', 'CFP Franc', '95.342501', '', 'Active', 'No', 'No', '新喀里多尼亚', '0', 4, 10, 'Noumea', '98800'),
(229, 'Polynesia (French)', 'PYF', 'PF', 'XPF', '', 'CFP Franc', '95.342501', '', 'Active', 'No', 'No', '塔希提（法属波利尼西亚）', '0', 4, 10, 'Papeete', '98714'),
(230, 'Wallis and Futuna Islands', 'WLF', 'WF', 'XPF', '', 'CFP Franc', '95.342501', '', 'Active', 'No', 'No', '瓦利斯和富图纳', '0', 4, 10, 'Mata-Utu', '98600'),
(231, 'Yemen', 'YEM', 'YE', 'YER', '', 'Yemeni Rial', '215.040559', '', 'Active', 'No', 'No', '也门共和国', '2', 1, 10, 'Sanaa', '2045'),
(232, 'South Africa', 'ZAF', 'ZA', 'ZAR', 'R', 'South African Rand', '11.10925', '', 'Active', 'No', 'No', '南非', '4', 3, 9, 'Pretoria', '0084'),
(233, 'Zambia', 'ZMB', 'ZM', 'ZMK', '', 'Zambian Kwacha', '4856.902232', '', 'Active', 'No', 'No', '赞比亚', '4', 3, 10, 'Lusaka', '1753'),
(234, 'Zimbabwe', 'ZWE', 'ZW', 'ZWL', '', 'Zimbabwean Dollar', '322.355011', '', 'Active', 'No', 'No', '津巴布韦', '4', 3, 10, 'Harare', '00263');




-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_code` varchar(10) NOT NULL,
  `currency_symbol` varchar(25) NOT NULL,
  `currency_name` varchar(250) NOT NULL,
  `exchange_rate` varchar(20) NOT NULL,
  `exchange_rate_static` varchar(20) NOT NULL,
  `paypal_supported` enum('Yes','No') NOT NULL,
  `display_currency` enum('Yes','No') NOT NULL,
  `status` enum('Active','InActive') NOT NULL DEFAULT 'Active',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Ind_currency_status` (`currency_code`,`status`),
  KEY `Ind_display_currency` (`display_currency`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` (`id`, `currency_code`, `currency_symbol`, `currency_name`, `exchange_rate`, `exchange_rate_static`, `paypal_supported`, `display_currency`, `status`, `created_at`, `updated_at`) VALUES
(1, 'USD', '$', 'United States Dollar', '1', '', 'No', 'Yes', 'Active', Now(), Now()),
(2, 'AED', '', 'United Arab Emirates Dirham', '3.672688', '', 'No', 'No', 'Active', Now(), Now()),
(3, 'AFN', '', 'Afghan Afghani', '48.181299', '', 'No', 'No', 'Active', Now(), Now()),
(4, 'ALL', '', 'Albanian Lek', '109.734999', '', 'No', 'No', 'Active', Now(), Now()),
(5, 'AMD', '', 'Armenian Dram', '410.544995', '', 'No', 'No', 'Active', Now(), Now()),
(6, 'ANG', '', 'Netherlands Antillean Guilder', '1.7738', '', 'No', 'No', 'Active', Now(), Now()),
(7, 'AOA', '', 'Angolan Kwanza', '95.489998', '', 'No', 'No', 'Active', Now(), Now()),
(8, 'ARS', '', 'Argentine Peso', '4.615274', '', 'No', 'No', 'Active', Now(), Now()),
(9, 'AUD', '$', 'Australian Dollar', '1.146492', '', 'No', 'No', 'Active', Now(), Now()),
(10, 'AWG', '', 'Aruban Florin', '1.7901', '', 'No', 'No', 'Active', Now(), Now()),
(11, 'AZN', '', 'Azerbaijani Manat', '0.7854', '', 'No', 'No', 'Active', Now(), Now()),
(12, 'BAM', '', 'Bosnia-Herzegovina Convertible Mark', '1.559625', '', 'No', 'No', 'Active', Now(), Now()),
(13, 'BBD', '', 'Barbadian Dollar', '2', '', 'No', 'No', 'Active', Now(), Now()),
(14, 'BDT', '', 'Bangladeshi Taka', '81.209433', '', 'No', 'No', 'Active', Now(), Now()),
(15, 'BGN', '', 'Bulgarian Lev', '1.558388', '', 'No', 'No', 'Active', Now(), Now()),
(16, 'BHD', '', 'Bahraini Dina', '0.376694', '', 'No', 'No', 'Active', Now(), Now()),
(17, 'BIF', '', 'Burundian Franc', '1434.126667', '', 'No', 'No', 'Active', Now(), Now()),
(18, 'BMD', '', 'Bermudan Dollar', '1', '', 'No', 'No', 'Active', Now(), Now()),
(19, 'BND', '', 'Brunei Dollar', '1.244213', '', 'No', 'No', 'Active', Now(), Now()),
(20, 'BOB', '', 'Bolivian Boliviano', '6.960804', '', 'No', 'No', 'Active', Now(), Now()),
(21, 'BRL', 'R$', 'Brazilian Real', '2.607643', '', 'No', 'No', 'Active', Now(), Now()),
(22, 'BSD', '', 'Bahamian Dollar', '1', '', 'No', 'No', 'Active', Now(), Now()),
(23, 'BTN', '', 'Bhutanese Ngultrum', '51.295', '', 'No', 'No', 'Active', Now(), Now()),
(24, 'BWP', '', 'Botswanan Pula', '7.694578', '', 'No', 'No', 'Active', Now(), Now()),
(25, 'BYR', '', 'Belarusian Ruble', '8359.9', '', 'No', 'No', 'Active', Now(), Now()),
(26, 'BZD', '', 'Belize Dollar', '1.88145', '', 'No', 'No', 'Active', Now(), Now()),
(27, 'CAD', '$', 'Canadian Dollar', '1.128132', '', 'No', 'No', 'Active', Now(), Now()),
(28, 'CDF', '', 'Congolese Franc', '923.415161', '', 'No', 'No', 'Active', Now(), Now()),
(29, 'CHF', 'CHF', 'Swiss Franc', '0.957061', '', 'No', 'No', 'Active', Now(), Now()),
(30, 'CLP', '', 'Chilean Peso', '481.812127', '', 'No', 'No', 'Active', Now(), Now()),
(31, 'CNY', '¥', 'Chinese Yuan Renminbi', '6.12722', '6.354264', 'No', 'No', 'Active', Now(), Now()),
(32, 'COP', '', 'Colombian Peso', '1812.72105', '', 'No', 'No', 'Active', Now(), Now()),
(33, 'CRC', '', 'Costa Rican Colon', '497.835031', '', 'No', 'No', 'Active', Now(), Now()),
(34, 'CUP', '', 'Cuban Peso', '1', '', 'No', 'No', 'Active', Now(), Now()),
(35, 'CVE', '', 'Cape Verdean Escudo', '88.679566', '', 'No', 'No', 'Active', Now(), Now()),
(36, 'CZK', 'K?', 'Czech Republic Koruna', '22.1789', '', 'No', 'No', 'Active', Now(), Now()),
(37, 'DJF', '', 'Djiboutian Franc', '177.753332', '', 'No', 'No', 'Active', Now(), Now()),
(38, 'DKK', 'kr', 'Danish Krone', '5.964679', '', 'No', 'No', 'Active', Now(), Now()),
(39, 'DOP', '', 'Dominican Peso', '38.891081', '', 'No', 'No', 'Active', Now(), Now()),
(40, 'DZD', '', 'Algerian Dinar', '80.414547', '', 'No', 'No', 'Active', Now(), Now()),
(41, 'EGP', '', 'Egyptian Pound', '6.088136', '', 'No', 'No', 'Active', Now(), Now()),
(42, 'ETB', '', 'Ethiopian Birr', '17.894417', '', 'No', 'No', 'Active', Now(), Now()),
(43, 'EUR', '&euro;', 'Euro', '0.798982', '', 'No', 'Yes', 'Active', Now(), Now()),
(44, 'FJD', '', 'Fijian Dollar', '1.77025', '', 'No', 'No', 'Active', Now(), Now()),
(45, 'FKP', '', 'Falkland Islands Pound', '0.629755', '', 'No', 'No', 'Active', Now(), Now()),
(46, 'GBP', '£', 'British Pound Sterling', '0.638797', '', 'No', 'No', 'Active', Now(), Now()),
(47, 'GEL', '', 'Georgian Lari', '1.726683', '', 'No', 'No', 'Active', Now(), Now()),
(48, 'GHS', '', 'Ghanaian Cedi', '1.931433', '', 'No', 'No', 'Active', Now(), Now()),
(49, 'GIP', '', 'Gibraltar Pound', '0.62767', '', 'No', 'No', 'Active', Now(), Now()),
(50, 'GMD', '', 'Gambian Dalasi', '31.881101', '', 'No', 'No', 'Active', Now(), Now()),
(51, 'GNF', '', 'Guinean Franc', '7156.966667', '', 'No', 'No', 'Active', Now(), Now()),
(52, 'GTQ', '', 'Guatemalan Quetzal', '7.829517', '', 'No', 'No', 'Active', Now(), Now()),
(53, 'GYD', '', 'Guyanaese Dollar', '202.949998', '', 'No', 'No', 'Active', Now(), Now()),
(54, 'HKD', '$', 'Hong Kong Dollar', '7.754703', '', 'No', 'No', 'Active', Now(), Now()),
(55, 'HNL', '', 'Honduran Lempira', '19.46019', '', 'No', 'No', 'Active', Now(), Now()),
(56, 'HRK', '', 'Croatian Kuna', '5.969697', '', 'No', 'No', 'Active', Now(), Now()),
(57, 'HTG', '', 'Haitian Gourde', '41.8571', '', 'No', 'No', 'Active', Now(), Now()),
(58, 'HUF', 'Ft', 'Hungarian Forint', '245.534701', '', 'No', 'No', 'Active', Now(), Now()),
(59, 'IDR', '', 'Indonesian Rupiah', '9500.42738', '', 'No', 'No', 'Active', Now(), Now()),
(60, 'ILS', '?', 'Israeli New Sheqel', '3.825039', '', 'No', 'No', 'Active', Now(), Now()),
(61, 'INR', 'Rs', 'Indian Rupee', '61.7265', '', 'No', 'Yes', 'Active', Now(), Now()),
(62, 'IQD', '', 'Iraqi Dinar', '1158.33', '', 'No', 'No', 'Active', Now(), Now()),
(63, 'IRR', '', 'Iranian Rial', '12223.726667', '', 'No', 'No', 'Active', Now(), Now()),
(64, 'ISK', '', 'Icelandic Krona', '118.62', '', 'No', 'No', 'Active', Now(), Now()),
(65, 'JMD', '', 'Jamaican Dollar', '88.8657', '', 'No', 'No', 'Active', Now(), Now()),
(66, 'JOD', '', 'Jordanian Dinar', '0.70849', '', 'No', 'No', 'Active', Now(), Now()),
(67, 'JPY', '¥', 'Japanese Yen', '116.5026', '', 'No', 'No', 'Active', Now(), Now()),
(68, 'KES', '', 'Kenyan Shilling', '83.983915', '', 'No', 'No', 'Active', Now(), Now()),
(69, 'KGS', '', 'Kyrgystani Som', '44.952151', '', 'No', 'No', 'Active', Now(), Now()),
(70, 'KHR', '', 'Cambodian Riel', '4052.19', '', 'No', 'No', 'Active', Now(), Now()),
(71, 'KMF', '', 'Comorian Franc', '396.545429', '', 'No', 'No', 'Active', Now(), Now()),
(72, 'KPW', '', 'North Korean Won', '900', '', 'No', 'No', 'Active', Now(), Now()),
(73, 'KRW', '', 'South Korean Won', '1130.495862', '', 'No', 'No', 'Active', Now(), Now()),
(74, 'KWD', '', 'Kuwaiti Dinar', '0.281952', '', 'No', 'No', 'Active', Now(), Now()),
(75, 'KZT', '', 'Kazakhstani Tenge', '148.486876', '', 'No', 'No', 'Active', Now(), Now()),
(76, 'LAK', '', 'Laotian Kip', '7982.166667', '', 'No', 'No', 'Active', Now(), Now()),
(77, 'LBP', '', 'Lebanese Pound', '1500.418525', '', 'No', 'No', 'Active', Now(), Now()),
(78, 'LKR', '', 'Sri Lankan Rupee', '132.321911', '', 'No', 'No', 'Active', Now(), Now()),
(79, 'LRD', '', 'Liberian Dollar', '74.1125', '', 'No', 'No', 'Active', Now(), Now()),
(80, 'LSL', '', 'Lesotho Loti', '8.259983', '', 'No', 'No', 'Active', Now(), Now()),
(81, 'LTL', '', 'Lithuanian Litas', '2.750449', '', 'No', 'No', 'Active', Now(), Now()),
(82, 'LVL', '', 'Latvian Lats', '0.554573', '', 'No', 'No', 'Active', Now(), Now()),
(83, 'LYD', '', 'Libyan Dinar', '1.256817', '', 'No', 'No', 'Active', Now(), Now()),
(84, 'MAD', '', 'Moroccan Dirham', '8.801646', '', 'No', 'No', 'Active', Now(), Now()),
(85, 'MDL', '', 'Moldovan Leu', '12.436819', '', 'No', 'No', 'Active', Now(), Now()),
(86, 'MGA', '', 'Malagasy Ariary', '2228.966667', '', 'No', 'No', 'Active', Now(), Now()),
(87, 'MKD', '', 'Macedonian Denar', '49.998625', '', 'No', 'No', 'Active', Now(), Now()),
(88, 'MMK', '', 'Myanma Kyat', '871.705', '', 'No', 'No', 'Active', Now(), Now()),
(89, 'MNT', '', 'Mongolian Tugrik', '1397.929993', '', 'No', 'No', 'Active', Now(), Now()),
(90, 'MOP', '', 'Macanese Pataca', '7.9522', '', 'No', 'No', 'Active', Now(), Now()),
(91, 'MRO', '', 'Mauritanian Ouguiya', '300.681667', '', 'No', 'No', 'Active', Now(), Now()),
(92, 'MUR', '', 'Mauritian Rupee', '30.411164', '', 'No', 'No', 'Active', Now(), Now()),
(93, 'MVR', '', 'Maldivian Rufiyaa', '15.334333', '', 'No', 'No', 'Active', Now(), Now()),
(94, 'MWK', '', 'Malawian Kwacha', '273.352508', '', 'No', 'No', 'Active', Now(), Now()),
(95, 'MXN', '$', 'Mexican Peso', '13.57504', '', 'No', 'No', 'Active', Now(), Now()),
(96, 'MYR', 'RM', 'Malaysian Ringgit', '3.351279', '', 'No', 'No', 'Active', Now(), Now()),
(97, 'MZN', '', 'Mozambican Metical', '28.50875', '', 'No', 'No', 'Active', Now(), Now()),
(98, 'NAD', '', 'Namibian Dollar', '8.255996', '', 'No', 'No', 'Active', Now(), Now()),
(99, 'NGN', '', 'Nigerian Naira', '157.304594', '', 'No', 'No', 'Active', Now(), Now()),
(100, 'NIO', '', 'Nicaraguan Cordoba', '23.626742', '', 'No', 'No', 'Active', Now(), Now()),
(101, 'NOK', 'kr', 'Norwegian Krone', '5.854828', '', 'No', 'No', 'Active', Now(), Now()),
(102, 'NPR', '', 'Nepalese Rupee', '88.11028', '', 'No', 'No', 'Active', Now(), Now()),
(103, 'NZD', '$', 'New Zealand Dollar', '1.224302', '', 'No', 'No', 'Active', Now(), Now()),
(104, 'OMR', '', 'Omani Rial', '0.384812', '', 'No', 'No', 'Active', Now(), Now()),
(105, 'PAB', '', 'Panamanian Balboa', '1', '', 'No', 'No', 'Active', Now(), Now()),
(106, 'PEN', '', 'Peruvian Nuevo Sol', '2.603013', '', 'No', 'No', 'Active', Now(), Now()),
(107, 'PGK', '', 'Papua New Guinean Kina', '2.054549', '', 'No', 'No', 'Active', Now(), Now()),
(108, 'PHP', '?', 'Philippine Peso', '44.9356', '', 'No', 'No', 'Active', Now(), Now()),
(109, 'PKR', '', 'Pakistani Rupee', '101.9444', '94.023294', 'No', 'No', 'Active', Now(), Now()),
(110, 'PLN', 'z?', 'Polish Zloty', '3.382951', '', 'No', 'No', 'Active', Now(), Now()),
(111, 'PYG', '', 'Paraguayan Guarani', '4410.84861', '', 'No', 'No', 'Active', Now(), Now()),
(112, 'QAR', '', 'Qatari Rial', '3.640912', '', 'No', 'No', 'Active', Now(), Now()),
(113, 'RON', '', 'Romanian Leu', '3.577474', '', 'No', 'No', 'Active', Now(), Now()),
(114, 'RSD', '', 'Serbian Dinar', '93.726442', '', 'No', 'No', 'Active', Now(), Now()),
(115, 'RUB', '', 'Russian Ruble', '31.697677', '', 'No', 'No', 'Active', Now(), Now()),
(116, 'RWF', '', 'Rwandan Franc', '609.539388', '', 'No', 'No', 'Active', Now(), Now()),
(117, 'SAR', '', 'Saudi Riyal', '3.750176', '', 'No', 'No', 'Active', Now(), Now()),
(118, 'SBD', '', 'Solomon Islands Dollar', '7.065961', '', 'No', 'No', 'Active', Now(), Now()),
(119, 'SCR', '', 'Seychellois Rupee', '13.040057', '', 'No', 'No', 'Active', Now(), Now()),
(120, 'SDG', '', 'Sudanese Pound', '4.4152', '', 'No', 'No', 'Active', Now(), Now()),
(121, 'SEK', 'kr', 'Swedish Krona', '7.416207', '', 'No', 'No', 'Active', Now(), Now()),
(122, 'SGD', '$', 'Singapore Dollar', '1.297386', '', 'No', 'No', 'Active', Now(), Now()),
(123, 'SHP', '', 'Saint Helena Pound', '0.629755', '', 'No', 'No', 'Active', Now(), Now()),
(124, 'SLL', '', 'Sierra Leonean Leone', '4361.775363', '', 'No', 'No', 'Active', Now(), Now()),
(125, 'SOS', '', 'Somali Shilling', '1617.456667', '', 'No', 'No', 'Active', Now(), Now()),
(126, 'SRD', '', 'Surinamese Dollar', '3.275', '', 'No', 'No', 'Active', Now(), Now()),
(127, 'STD', '', 'Sao Tomé and Príncipe Dobra', '20072.246667', '', 'No', 'No', 'Active', Now(), Now()),
(128, 'SVC', '', 'Salvadoran Colon', '8.71802', '', 'No', 'No', 'Active', Now(), Now()),
(129, 'SYP', '', 'Syrian Pound', '65.246168', '', 'No', 'No', 'Active', Now(), Now()),
(130, 'SZL', '', 'Swazi Lilangeni', '8.261117', '', 'No', 'No', 'Active', Now(), Now()),
(131, 'THB', '?', 'Thai Baht', '32.78137', '', 'No', 'No', 'Active', Now(), Now()),
(132, 'TJS', '', 'Tajikistani Somoni', '4.5819', '', 'No', 'No', 'Active', Now(), Now()),
(133, 'TMT', '', 'Turkmenistani Manat', '2.8503', '', 'No', 'No', 'Active', Now(), Now()),
(134, 'TND', '', 'Tunisian Dinar', '1.596925', '', 'No', 'No', 'Active', Now(), Now()),
(135, 'TOP', '', 'Tongan Pa''anga', '1.751448', '', 'No', 'No', 'Active', Now(), Now()),
(136, 'TRY', '', 'Turkish Lira', '1.795137', '', 'No', 'No', 'Active', Now(), Now()),
(137, 'TTD', '', 'Trinidad and Tobago Dollar', '6.376663', '', 'No', 'No', 'Active', Now(), Now()),
(138, 'TWD', 'NT$', 'New Taiwan Dollar', '30.72682', '', 'No', 'No', 'Active', Now(), Now()),
(139, 'TZS', '', 'Tanzanian Shilling', '1567.94676', '', 'No', 'No', 'Active', Now(), Now()),
(140, 'UAH', '', 'Ukrainian Hryvnia', '8.074449', '', 'No', 'No', 'Active', Now(), Now()),
(141, 'UGX', '', 'Ugandan Shilling', '2499.07562', '', 'No', 'No', 'Active', Now(), Now()),
(142, 'UYU', '', 'Uruguayan Peso', '21.227465', '', 'No', 'No', 'Active', Now(), Now()),
(143, 'UZS', '', 'Uzbekistan Som', '1909.388954', '', 'No', 'No', 'Active', Now(), Now()),
(144, 'VEF', '', 'Venezuelan Bolívar', '4.294323', '', 'No', 'No', 'Active', Now(), Now()),
(145, 'VND', '', 'Vietnamese Dong', '20808.845825', '', 'No', 'No', 'Active', Now(), Now()),
(146, 'VUV', '', 'Vanuatu Vatu', '91.25', '', 'No', 'No', 'Active', Now(), Now()),
(147, 'WST', '', 'Samoan Tala', '2.309777', '', 'No', 'No', 'Active', Now(), Now()),
(148, 'XAF', '', 'CFA Franc BEAC', '522.932787', '', 'No', 'No', 'Active', Now(), Now()),
(149, 'XCD', '', 'East Caribbean Dollar', '2.70175', '', 'No', 'No', 'Active', Now(), Now()),
(150, 'XDR', '', 'Special Drawing Rights', '0.660259', '', 'No', 'No', 'Active', Now(), Now()),
(151, 'XOF', '', 'CFA Franc BCEAO', '524.663337', '', 'No', 'No', 'Active', Now(), Now()),
(152, 'XPF', '', 'CFP Franc', '95.342501', '', 'No', 'No', 'Active', Now(), Now()),
(153, 'YER', '', 'Yemeni Rial', '215.040559', '', 'No', 'No', 'Active', Now(), Now()),
(154, 'ZAR', 'R', 'South African Rand', '11.10925', '', 'No', 'No', 'Active', Now(), Now()),
(155, 'ZMK', '', 'Zambian Kwacha', '4856.902232', '', 'No', 'No', 'Active', Now(), Now()),
(156, 'ZWL', '', 'Zimbabwean Dollar', '322.355011', '', 'No', 'No', 'Active', Now(), Now());